/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NoticeTemplate
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Notice Template ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notice Template Version", example="11111111-1111-1111-1111-111111111111")
    private String version;
    @Schema(description="Notice Type")
    private NoticeType type;
    @Schema(description="Is Notice Template Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Notice Template Name", example="Default Hold Notice")
    private String name;
    @Schema(description="Notice Template Description", example="This is a sample description")
    private String description;
    @Schema(description="Notice Template Subject", example="Project X Legal Hold Notice")
    private String subject;
    @Schema(description="Notice Template Message (Markdown)", example="Sample notice template message")
    private String message;
    @Schema(description="Notice Parameters")
    private Map<String, Parameter> parameters;
    @Schema(description="Notice Survey Form Options")
    private List<FormOption> surveyFormOptions;

    @Override
    public NoticeTemplate clone() {
        NoticeTemplate clone = (NoticeTemplate)super.clone();
        if (this.parameters != null) {
            clone.setParameters(new HashMap<String, Parameter>(this.parameters));
        }
        if (this.surveyFormOptions != null) {
            clone.surveyFormOptions = new ArrayList<FormOption>();
            for (FormOption formOption : this.surveyFormOptions) {
                clone.surveyFormOptions.add(new FormOption(formOption));
            }
        }
        return clone;
    }

    @JsonIgnore
    public boolean requiresDataRepository() {
        if (this.surveyFormOptions != null) {
            for (FormOption formOption : this.surveyFormOptions) {
                if (!FormElementType.DATA_UPLOAD.equals((Object)formOption.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean hasSurveyFormOptions() {
        List<FormOption> surveyFormOptions = this.getSurveyFormOptions();
        if (surveyFormOptions != null) {
            for (FormOption formOption : surveyFormOptions) {
                if (!formOption.getEnabled() || FormElementType.HEADER.equals((Object)formOption.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void resetVersion() {
        this.version = UidUtils.getRandom();
    }

    public NoticeType getType() {
        return this.type;
    }

    public void setType(NoticeType type) {
        this.type = type;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<FormOption> getSurveyFormOptions() {
        return this.surveyFormOptions;
    }

    public void setSurveyFormOptions(List<FormOption> surveyFormOptions) {
        this.surveyFormOptions = surveyFormOptions;
    }

    public NoticeTemplate cloneLimited() {
        NoticeTemplate limited = new NoticeTemplate();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.type = this.getType();
        limited.setUserPermissions(this.cloneUserPermissions());
        return limited;
    }
}

