/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notificationrule;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.models.api.notificationrule.RuleType;
import com.nuix.automate.utils.models.internal.job.JobEvent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;

public class NotificationRule
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Notification Rule ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notification Rule Name", example="Notify submitters")
    private String name;
    @Schema(description="Notification Rule Description", example="Send a notification to submitters when the job finishes")
    private String description;
    @Schema(description="Notification Rule Triggers")
    private SortedSet<JobEvent> triggers;
    @Schema(description="Notification Rule Type")
    private RuleType ruleType;
    @Schema(description="Notification Rule Status")
    private Status status;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SortedSet<JobEvent> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(SortedSet<JobEvent> triggers) {
        this.triggers = triggers;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    @Override
    public NotificationRule clone() {
        NotificationRule clonedObject = (NotificationRule)super.clone();
        clonedObject.triggers = new TreeSet<JobEvent>();
        if (this.triggers != null) {
            clonedObject.triggers.addAll(this.triggers);
        }
        return clonedObject;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Notification " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getTriggers() == null) {
            this.setTriggers(new TreeSet<JobEvent>());
        }
        if (this.getRuleType() == null) {
            this.setRuleType(RuleType.WEBHOOK);
        }
    }

    public NotificationRule cloneLimited() {
        NotificationRule limited = new NotificationRule();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.ruleType = this.getRuleType();
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.triggers = new TreeSet<JobEvent>();
        return limited;
    }
}

