/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.resourcepool;

import com.nuix.automate.utils.models.api.resourcepool.AzureVmType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class AzureResourcePoolSettings
implements Serializable {
    @Schema(description="Azure Environment", example="Microsoft Commercial")
    private String environment;
    @Schema(description="Azure Tenant", example="11111111-1111-1111-1111-111111111111")
    private String tenant;
    @Schema(description="App ID", example="11111111-1111-1111-1111-111111111111")
    private String appId;
    @Schema(description="Subscription ID", example="11111111-1111-1111-1111-111111111111")
    private String subscriptionId;
    @Schema(description="VM Names", example="[\"Server1\",\"Server2\"]")
    private Set<String> vmNames;
    @Schema(description="Azure Custom VM ID", example="11111111-1111-1111-1111-111111111111")
    private String customVmImageId;
    @Schema(description="Azure Custom VM Username", example="Admin5")
    private String customVmUsername;
    @Schema(description="VM Disk Size (GB)", example="100")
    private Integer diskSize;
    @Schema(description="Max Concurrent Instances", example="4")
    private Integer maxConcurrentInstances;
    @Schema(description="Azure Network Name", example="Network 1")
    private String networkName;
    @Schema(description="Azure Network Name", example="default")
    private String networkSubnetName;
    @Schema(description="Azure Network Security Group", example="sample-nsg")
    private String networkSecurityGroup;
    @Schema(description="Azure Location", example="westus")
    private String region;
    @Schema(description="Azure Resource Group ID", example="11111111-1111-1111-1111-111111111111")
    private String resourceGroupId;
    @Schema(description="Azure VM Size", example="Basic_A0")
    private String vmSize;
    @Schema(description="Azure VM Type")
    private AzureVmType vmType;
    @Schema(description="Azure Tag Name", example="instance-type")
    private String tagName;
    @Schema(description="Azure Tag Value", example="automate")
    private String tagValue;

    public String getAppId() {
        return this.appId;
    }

    public AzureResourcePoolSettings() {
    }

    public AzureResourcePoolSettings(com.nuix.automate.utils.models.internal.resourcepool.AzureResourcePoolSettings copy) {
        this.environment = copy.getEnvironment();
        this.tenant = copy.getTenant();
        this.appId = copy.getAppId();
        this.subscriptionId = copy.getSubscriptionId();
        this.vmNames = new HashSet<String>();
        if (copy.getVmNames() != null) {
            this.vmNames.addAll(copy.getVmNames());
        }
        this.customVmImageId = copy.getCustomVmImageId();
        this.diskSize = copy.getDiskSize();
        this.maxConcurrentInstances = copy.getMaxConcurrentInstances();
        this.networkName = copy.getNetworkName();
        this.networkSubnetName = copy.getNetworkSubnetName();
        this.networkSecurityGroup = copy.getNetworkSecurityGroup();
        this.region = copy.getRegion();
        this.resourceGroupId = copy.getResourceGroupId();
        this.vmSize = copy.getVmSize();
        this.vmType = copy.getVmType();
        this.tagName = copy.getTagName();
        this.tagValue = copy.getTagValue();
        this.customVmUsername = copy.getCustomVmUsername();
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public Set<String> getVmNames() {
        return this.vmNames;
    }

    public void setVmNames(Set<String> vmNames) {
        this.vmNames = vmNames;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getCustomVmImageId() {
        return this.customVmImageId;
    }

    public void setCustomVmImageId(String customVmImageId) {
        this.customVmImageId = customVmImageId;
    }

    public Integer getDiskSize() {
        return this.diskSize;
    }

    public void setDiskSize(Integer diskSize) {
        this.diskSize = diskSize;
    }

    public Integer getMaxConcurrentInstances() {
        return this.maxConcurrentInstances;
    }

    public void setMaxConcurrentInstances(Integer maxConcurrentInstances) {
        this.maxConcurrentInstances = maxConcurrentInstances;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public String getNetworkSubnetName() {
        return this.networkSubnetName;
    }

    public void setNetworkSubnetName(String networkSubnetName) {
        this.networkSubnetName = networkSubnetName;
    }

    public String getNetworkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public void setNetworkSecurityGroup(String networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public void setResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public void setVmSize(String vmSize) {
        this.vmSize = vmSize;
    }

    public AzureVmType getVmType() {
        return this.vmType;
    }

    public void setVmType(AzureVmType vmType) {
        this.vmType = vmType;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public String getCustomVmUsername() {
        return this.customVmUsername;
    }

    public void setCustomVmUsername(String customVmUsername) {
        this.customVmUsername = customVmUsername;
    }
}

