/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.resourcepool;

import com.nuix.automate.utils.models.api.resourcepool.AwsResourcePoolSettings;
import com.nuix.automate.utils.models.api.resourcepool.AzureResourcePoolSettings;
import com.nuix.automate.utils.models.api.resourcepool.InstanceIdleAction;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class CloudResourcePoolSettings
implements Serializable {
    @Schema(description="Server Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;
    @Schema(description="Main Engine License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String nuixLicenceSourceId;
    @Schema(description="Main Engine Target Workers Count", example="4")
    private Integer targetNuixWorkers;
    @Schema(description="Main Engine Minimum Workers Count", example="2")
    private Integer minNuixWorkers;
    @Schema(description="Main Engine Instance Idle Action")
    private InstanceIdleAction instanceIdleAction;
    @Schema(description="Force Main Engine Idle Action Between Jobs?", example="false")
    private Boolean forceIdleActionBetweenJobs;
    @Schema(description="Use Remote Engines?", example="false")
    private Boolean useRemoteEngines;
    @Schema(description="Remote Engines License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String remoteNuixLicenceSourceId;
    @Schema(description="Remote Engines Target Workers Count", example="4")
    private Integer remoteTargetNuixWorkers;
    @Schema(description="Remote Engines Minimum Workers Count", example="2")
    private Integer remoteMinNuixWorkers;
    @Schema(description="Remote Engine Instance Idle Action")
    private InstanceIdleAction remoteInstanceIdleAction;
    @Schema(description="Don't Trigger Allow Remote Engine to Go Idle During Job", example="false")
    private Boolean remoteNoIdleDuringJob;
    @Schema(description="Don't Trigger Allow Remote Engine to Go Idle Before First Job", example="false")
    private Boolean remoteNoIdleBeforeFirstJob;
    @Schema(description="Main Engine AWS Settings")
    private AwsResourcePoolSettings awsSettings;
    @Schema(description="Remote Engine AWS Settings")
    private AwsResourcePoolSettings remoteAwsSettings;
    @Schema(description="Main Engine Azure Settings")
    private AzureResourcePoolSettings azureSettings;
    @Schema(description="Remote Engine Azure Settings")
    private AzureResourcePoolSettings remoteAzureSettings;

    public CloudResourcePoolSettings() {
    }

    public CloudResourcePoolSettings(com.nuix.automate.utils.models.internal.resourcepool.CloudResourcePoolSettings copy) {
        this.nuixLicenceSourceId = copy.getNuixLicenceSourceId();
        this.targetNuixWorkers = copy.getTargetNuixWorkers();
        this.minNuixWorkers = copy.getMinNuixWorkers();
        this.whitelistedCertFingerprints = new HashSet<String>();
        this.instanceIdleAction = copy.getInstanceIdleAction();
        this.forceIdleActionBetweenJobs = copy.getForceIdleActionBetweenJobs();
        this.remoteNuixLicenceSourceId = copy.getRemoteNuixLicenceSourceId();
        this.remoteTargetNuixWorkers = copy.getRemoteTargetNuixWorkers();
        this.remoteMinNuixWorkers = copy.getRemoteMinNuixWorkers();
        this.remoteInstanceIdleAction = copy.getRemoteInstanceIdleAction();
        this.useRemoteEngines = copy.getUseRemoteEngines();
        this.remoteNoIdleDuringJob = copy.getRemoteNoIdleDuringJob();
        this.remoteNoIdleBeforeFirstJob = copy.getRemoteNoIdleBeforeFirstJob();
        if (copy.getWhitelistedCertFingerprints() != null) {
            this.whitelistedCertFingerprints.addAll(copy.getWhitelistedCertFingerprints());
        }
        if (copy.getAwsSettings() != null) {
            this.awsSettings = new AwsResourcePoolSettings(copy.getAwsSettings());
        }
        if (copy.getRemoteAwsSettings() != null) {
            this.remoteAwsSettings = new AwsResourcePoolSettings(copy.getRemoteAwsSettings());
        }
        if (copy.getAzureSettings() != null) {
            this.azureSettings = new AzureResourcePoolSettings(copy.getAzureSettings());
        }
        if (copy.getRemoteAzureSettings() != null) {
            this.remoteAzureSettings = new AzureResourcePoolSettings(copy.getRemoteAzureSettings());
        }
    }

    public AwsResourcePoolSettings getAwsSettings() {
        return this.awsSettings;
    }

    public void setAwsSettings(AwsResourcePoolSettings awsSettings) {
        this.awsSettings = awsSettings;
    }

    public AzureResourcePoolSettings getAzureSettings() {
        return this.azureSettings;
    }

    public void setAzureSettings(AzureResourcePoolSettings azureSettings) {
        this.azureSettings = azureSettings;
    }

    public Boolean getForceIdleActionBetweenJobs() {
        return this.forceIdleActionBetweenJobs;
    }

    public void setForceIdleActionBetweenJobs(Boolean forceIdleActionBetweenJobs) {
        this.forceIdleActionBetweenJobs = forceIdleActionBetweenJobs;
    }

    public InstanceIdleAction getInstanceIdleAction() {
        return this.instanceIdleAction;
    }

    public void setInstanceIdleAction(InstanceIdleAction instanceIdleAction) {
        this.instanceIdleAction = instanceIdleAction;
    }

    public String getNuixLicenceSourceId() {
        return this.nuixLicenceSourceId;
    }

    public void setNuixLicenceSourceId(String nuixLicenceSourceId) {
        this.nuixLicenceSourceId = nuixLicenceSourceId;
    }

    public Integer getTargetNuixWorkers() {
        return this.targetNuixWorkers;
    }

    public void setTargetNuixWorkers(Integer targetNuixWorkers) {
        this.targetNuixWorkers = targetNuixWorkers;
    }

    public Integer getMinNuixWorkers() {
        if (this.minNuixWorkers == null) {
            return this.targetNuixWorkers;
        }
        return this.minNuixWorkers;
    }

    public void setMinNuixWorkers(Integer minNuixWorkers) {
        this.minNuixWorkers = minNuixWorkers;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> fingerprints) {
        this.whitelistedCertFingerprints = fingerprints;
    }

    public String getRemoteNuixLicenceSourceId() {
        return this.remoteNuixLicenceSourceId;
    }

    public void setRemoteNuixLicenceSourceId(String remoteNuixLicenceSourceId) {
        this.remoteNuixLicenceSourceId = remoteNuixLicenceSourceId;
    }

    public Integer getRemoteTargetNuixWorkers() {
        return this.remoteTargetNuixWorkers;
    }

    public void setRemoteTargetNuixWorkers(Integer remoteTargetNuixWorkers) {
        this.remoteTargetNuixWorkers = remoteTargetNuixWorkers;
    }

    public Integer getRemoteMinNuixWorkers() {
        return this.remoteMinNuixWorkers;
    }

    public void setRemoteMinNuixWorkers(Integer remoteMinNuixWorkers) {
        this.remoteMinNuixWorkers = remoteMinNuixWorkers;
    }

    public InstanceIdleAction getRemoteInstanceIdleAction() {
        return this.remoteInstanceIdleAction;
    }

    public void setRemoteInstanceIdleAction(InstanceIdleAction remoteInstanceIdleAction) {
        this.remoteInstanceIdleAction = remoteInstanceIdleAction;
    }

    public AwsResourcePoolSettings getRemoteAwsSettings() {
        return this.remoteAwsSettings;
    }

    public void setRemoteAwsSettings(AwsResourcePoolSettings remoteAwsSettings) {
        this.remoteAwsSettings = remoteAwsSettings;
    }

    public Boolean getUseRemoteEngines() {
        return this.useRemoteEngines;
    }

    public void setUseRemoteEngines(Boolean useRemoteEngines) {
        this.useRemoteEngines = useRemoteEngines;
    }

    public Boolean getRemoteNoIdleDuringJob() {
        return this.remoteNoIdleDuringJob;
    }

    public void setRemoteNoIdleDuringJob(Boolean remoteNoIdleDuringJob) {
        this.remoteNoIdleDuringJob = remoteNoIdleDuringJob;
    }

    public Boolean getRemoteNoIdleBeforeFirstJob() {
        return this.remoteNoIdleBeforeFirstJob;
    }

    public void setRemoteNoIdleBeforeFirstJob(Boolean remoteNoIdleBeforeFirstJob) {
        this.remoteNoIdleBeforeFirstJob = remoteNoIdleBeforeFirstJob;
    }

    public AzureResourcePoolSettings getRemoteAzureSettings() {
        return this.remoteAzureSettings;
    }

    public void setRemoteAzureSettings(AzureResourcePoolSettings remoteAzureSettings) {
        this.remoteAzureSettings = remoteAzureSettings;
    }
}

