/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.resourcepool;

import com.nuix.automate.utils.models.api.resourcepool.AwsResourcePoolSettingsSubmission;
import com.nuix.automate.utils.models.api.resourcepool.AzureResourcePoolSettingsSubmission;
import com.nuix.automate.utils.models.api.resourcepool.InstanceIdleAction;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class CloudResourcePoolSettingsSubmission
implements Serializable {
    @Schema(description="Server Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;
    @Schema(description="Main Engine License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String nuixLicenceSourceId;
    @Schema(description="Main Engine Target Workers Count", example="4")
    private Integer targetNuixWorkers;
    @Schema(description="Main Engine Minimum Workers Count", example="2")
    private Integer minNuixWorkers;
    @Schema(description="Main Engine Instance Idle Action")
    private InstanceIdleAction instanceIdleAction;
    @Schema(description="Force Main Engine Idle Action Between Jobs?", example="false")
    private Boolean forceIdleActionBetweenJobs;
    @Schema(description="Use Remote Engines?", example="false")
    private Boolean useRemoteEngines;
    @Schema(description="Remote Engines License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String remoteNuixLicenceSourceId;
    @Schema(description="Remote Engines Target Workers Count", example="4")
    private Integer remoteTargetNuixWorkers;
    @Schema(description="Remote Engines Minimum Workers Count", example="2")
    private Integer remoteMinNuixWorkers;
    @Schema(description="Remote Engine Instance Idle Action")
    private InstanceIdleAction remoteInstanceIdleAction;
    @Schema(description="Don't Trigger Allow Remote Engine to Go Idle During Job", example="false")
    private Boolean remoteNoIdleDuringJob;
    @Schema(description="Don't Trigger Allow Remote Engine to Go Idle Before First Job", example="false")
    private Boolean remoteNoIdleBeforeFirstJob;
    @Schema(description="Main Engine AWS Settings")
    private AwsResourcePoolSettingsSubmission awsSettings;
    @Schema(description="Remote Engine AWS Settings")
    private AwsResourcePoolSettingsSubmission remoteAwsSettings;
    @Schema(description="Main Engine Azure Settings")
    private AzureResourcePoolSettingsSubmission azureSettings;

    public void removeSecrets() {
        if (this.awsSettings != null) {
            this.awsSettings.removeSecrets();
        }
        if (this.azureSettings != null) {
            this.azureSettings.removeSecrets();
        }
    }

    public CloudResourcePoolSettingsSubmission() {
    }

    public CloudResourcePoolSettingsSubmission(CloudResourcePoolSettingsSubmission copy) {
        this.nuixLicenceSourceId = copy.nuixLicenceSourceId;
        this.targetNuixWorkers = copy.targetNuixWorkers;
        this.minNuixWorkers = copy.minNuixWorkers;
        this.whitelistedCertFingerprints = new HashSet<String>();
        this.instanceIdleAction = copy.instanceIdleAction;
        this.forceIdleActionBetweenJobs = copy.forceIdleActionBetweenJobs;
        this.remoteNuixLicenceSourceId = copy.remoteNuixLicenceSourceId;
        this.remoteTargetNuixWorkers = copy.remoteTargetNuixWorkers;
        this.remoteMinNuixWorkers = copy.remoteMinNuixWorkers;
        this.remoteInstanceIdleAction = copy.remoteInstanceIdleAction;
        this.useRemoteEngines = copy.useRemoteEngines;
        this.remoteNoIdleDuringJob = copy.remoteNoIdleDuringJob;
        this.remoteNoIdleBeforeFirstJob = copy.remoteNoIdleBeforeFirstJob;
        if (copy.whitelistedCertFingerprints != null) {
            this.whitelistedCertFingerprints.addAll(copy.whitelistedCertFingerprints);
        }
        if (copy.awsSettings != null) {
            this.awsSettings = new AwsResourcePoolSettingsSubmission(copy.awsSettings);
        }
        if (copy.remoteAwsSettings != null) {
            this.remoteAwsSettings = new AwsResourcePoolSettingsSubmission(copy.remoteAwsSettings);
        }
        if (copy.azureSettings != null) {
            this.azureSettings = new AzureResourcePoolSettingsSubmission(copy.azureSettings);
        }
    }

    public AwsResourcePoolSettingsSubmission getAwsSettings() {
        return this.awsSettings;
    }

    public void setAwsSettings(AwsResourcePoolSettingsSubmission awsSettings) {
        this.awsSettings = awsSettings;
    }

    public AzureResourcePoolSettingsSubmission getAzureSettings() {
        return this.azureSettings;
    }

    public void setAzureSettings(AzureResourcePoolSettingsSubmission azureSettings) {
        this.azureSettings = azureSettings;
    }

    public Boolean getForceIdleActionBetweenJobs() {
        return this.forceIdleActionBetweenJobs;
    }

    public void setForceIdleActionBetweenJobs(Boolean forceIdleActionBetweenJobs) {
        this.forceIdleActionBetweenJobs = forceIdleActionBetweenJobs;
    }

    public InstanceIdleAction getInstanceIdleAction() {
        return this.instanceIdleAction;
    }

    public void setInstanceIdleAction(InstanceIdleAction instanceIdleAction) {
        this.instanceIdleAction = instanceIdleAction;
    }

    public String getNuixLicenceSourceId() {
        return this.nuixLicenceSourceId;
    }

    public void setNuixLicenceSourceId(String nuixLicenceSourceId) {
        this.nuixLicenceSourceId = nuixLicenceSourceId;
    }

    public Integer getTargetNuixWorkers() {
        return this.targetNuixWorkers;
    }

    public void setTargetNuixWorkers(Integer targetNuixWorkers) {
        this.targetNuixWorkers = targetNuixWorkers;
    }

    public Integer getMinNuixWorkers() {
        if (this.minNuixWorkers == null) {
            return this.targetNuixWorkers;
        }
        return this.minNuixWorkers;
    }

    public void setMinNuixWorkers(Integer minNuixWorkers) {
        this.minNuixWorkers = minNuixWorkers;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> fingerprints) {
        this.whitelistedCertFingerprints = fingerprints;
    }

    public String getRemoteNuixLicenceSourceId() {
        return this.remoteNuixLicenceSourceId;
    }

    public void setRemoteNuixLicenceSourceId(String remoteNuixLicenceSourceId) {
        this.remoteNuixLicenceSourceId = remoteNuixLicenceSourceId;
    }

    public Integer getRemoteTargetNuixWorkers() {
        return this.remoteTargetNuixWorkers;
    }

    public void setRemoteTargetNuixWorkers(Integer remoteTargetNuixWorkers) {
        this.remoteTargetNuixWorkers = remoteTargetNuixWorkers;
    }

    public Integer getRemoteMinNuixWorkers() {
        return this.remoteMinNuixWorkers;
    }

    public void setRemoteMinNuixWorkers(Integer remoteMinNuixWorkers) {
        this.remoteMinNuixWorkers = remoteMinNuixWorkers;
    }

    public InstanceIdleAction getRemoteInstanceIdleAction() {
        return this.remoteInstanceIdleAction;
    }

    public void setRemoteInstanceIdleAction(InstanceIdleAction remoteInstanceIdleAction) {
        this.remoteInstanceIdleAction = remoteInstanceIdleAction;
    }

    public AwsResourcePoolSettingsSubmission getRemoteAwsSettings() {
        return this.remoteAwsSettings;
    }

    public void setRemoteAwsSettings(AwsResourcePoolSettingsSubmission remoteAwsSettings) {
        this.remoteAwsSettings = remoteAwsSettings;
    }

    public Boolean getUseRemoteEngines() {
        return this.useRemoteEngines;
    }

    public void setUseRemoteEngines(Boolean useRemoteEngines) {
        this.useRemoteEngines = useRemoteEngines;
    }

    public Boolean getRemoteNoIdleDuringJob() {
        return this.remoteNoIdleDuringJob;
    }

    public void setRemoteNoIdleDuringJob(Boolean remoteNoIdleDuringJob) {
        this.remoteNoIdleDuringJob = remoteNoIdleDuringJob;
    }

    public Boolean getRemoteNoIdleBeforeFirstJob() {
        return this.remoteNoIdleBeforeFirstJob;
    }

    public void setRemoteNoIdleBeforeFirstJob(Boolean remoteNoIdleBeforeFirstJob) {
        this.remoteNoIdleBeforeFirstJob = remoteNoIdleBeforeFirstJob;
    }
}

