/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.resourcepool;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.TimestampedString;
import com.nuix.automate.utils.logging.CircularBufferLog;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.resourcepool.CloudResourcePoolSettings;
import com.nuix.automate.utils.models.api.resourcepool.Type;
import com.nuix.automate.utils.models.internal.resourcepool.AutoRegistrationSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResourcePool
extends UserPermissionModel
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePool.class);
    @Schema(description="Resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Resource Pool Name", example="Pool A")
    private String name;
    @Schema(description="Resource Pool Description", example="Sample description")
    private String description;
    @Schema(description="Is Resource Pool Enabled?", example="true")
    private Boolean active;
    @Schema(description="Engine IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private Set<String> engineIds;
    @Schema(description="Remote Engine IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private Set<String> remoteEngineIds;
    @Schema(description="Resource Pool Type")
    private Type type;
    @Schema(description="Resource Pool Cloud Settings")
    private CloudResourcePoolSettings cloudSettings;
    @Schema(description="Resource Pool Status")
    private Status status;
    @Schema(description="Is Engine Self-Registration Enabled?", example="true")
    private Boolean autoRegistrationEnabled;
    @Schema(description="Self-Registration Engine Settings")
    private AutoRegistrationSettings autoRegistrationSettings;
    private CircularBufferLog log;

    @Schema(description="Resource Pool Log")
    public List<TimestampedString> getLog() {
        return this.log.getLog();
    }

    public void clearLog() {
        this.log.clear();
    }

    public void addLog(String logLine) {
        LOGGER.info(logLine);
        this.log.addLog(logLine);
    }

    public boolean isCloud() {
        return this.type.equals((Object)Type.AWS) || this.type.equals((Object)Type.AZURE);
    }

    public ResourcePool() {
        this.log = new CircularBufferLog();
    }

    public ResourcePool(ResourcePoolModel copy) {
        this.id = copy.getId();
        this.name = copy.getName();
        this.description = copy.getDescription();
        this.engineIds = new HashSet<String>();
        if (copy.getEngineIds() != null) {
            this.engineIds.addAll(copy.getEngineIds());
        }
        this.remoteEngineIds = new HashSet<String>();
        if (copy.getRemoteEngineIds() != null) {
            this.remoteEngineIds.addAll(copy.getRemoteEngineIds());
        }
        this.type = copy.getType();
        this.active = copy.getActive();
        if (copy.getCloudSettings() != null) {
            this.cloudSettings = new CloudResourcePoolSettings(copy.getCloudSettings());
        }
        this.autoRegistrationEnabled = copy.getAutoRegistrationEnabled();
        if (Boolean.TRUE.equals(this.autoRegistrationEnabled) && copy.getAutoRegistrationSettings() != null) {
            this.autoRegistrationSettings = new AutoRegistrationSettings(copy.getAutoRegistrationSettings());
        }
        this.log = copy.getLog();
        if (copy.getStatus() != null) {
            this.status = copy.getStatus().clone();
        }
    }

    public void removeSecrets() {
        if (this.autoRegistrationSettings != null) {
            this.autoRegistrationSettings.removeSecrets();
        }
    }

    public CloudResourcePoolSettings getCloudSettings() {
        return this.cloudSettings;
    }

    public void setCloudSettings(CloudResourcePoolSettings cloudSettings) {
        this.cloudSettings = cloudSettings;
    }

    public Set<String> getEngineIds() {
        return this.engineIds;
    }

    public void setEngineIds(Set<String> engineIds) {
        this.engineIds = engineIds;
    }

    public Set<String> getRemoteEngineIds() {
        return this.remoteEngineIds;
    }

    public void setRemoteEngineIds(Set<String> remoteEngineIds) {
        this.remoteEngineIds = remoteEngineIds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "Resource Pool " + this.name + " (" + (Object)((Object)this.type) + ")";
    }

    public Boolean getAutoRegistrationEnabled() {
        return this.autoRegistrationEnabled;
    }

    public void setAutoRegistrationEnabled(Boolean autoRegistrationEnabled) {
        this.autoRegistrationEnabled = autoRegistrationEnabled;
    }

    public AutoRegistrationSettings getSelfRegistrationSettings() {
        return this.autoRegistrationSettings;
    }

    public void setSelfRegistrationSettings(AutoRegistrationSettings autoRegistrationSettings) {
        this.autoRegistrationSettings = autoRegistrationSettings;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ResourcePool cloneLimited() {
        ResourcePool limited = new ResourcePool();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.active = this.active;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.type = this.type;
        limited.engineIds = new HashSet<String>();
        limited.remoteEngineIds = new HashSet<String>();
        return limited;
    }
}

