/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.schedule;

import com.nuix.automate.utils.models.api.schedule.HttpVerb;
import com.nuix.automate.utils.models.api.schedule.Trigger;
import com.nuix.automate.utils.models.api.schedule.WebhookTriggerHeader;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class WebhookTrigger
extends Trigger
implements Serializable,
Cloneable {
    @Schema(description="HTTP Verb")
    private HttpVerb httpVerb;
    @Schema(description="Webhook Signature Key", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String signatureKey;
    @Schema(description="Path")
    private String accessKey;
    @Schema(description="URL")
    private String url;
    @Schema(description="Response Body")
    private String body;
    @Schema(description="Response Code", example="200")
    private Integer responseCode;
    @Schema(description="Response Headers")
    private List<WebhookTriggerHeader> headers;

    public HttpVerb getHttpVerb() {
        return this.httpVerb;
    }

    public void setHttpVerb(HttpVerb httpVerb) {
        this.httpVerb = httpVerb;
    }

    public String getSignatureKey() {
        return this.signatureKey;
    }

    public void setSignatureKey(String signatureKey) {
        this.signatureKey = signatureKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public List<WebhookTriggerHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<WebhookTriggerHeader>();
        }
        return this.headers;
    }

    public void setHeaders(List<WebhookTriggerHeader> headers) {
        this.headers = headers;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        WebhookTrigger webhookTrigger = (WebhookTrigger)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.httpVerb, (Object)webhookTrigger.httpVerb).append((Object)this.accessKey, (Object)webhookTrigger.accessKey);
        if (this.signatureKey == null && webhookTrigger.signatureKey != null || this.signatureKey != null && webhookTrigger.signatureKey == null) {
            equalsBuilder.append(true, false);
        } else if (this.signatureKey != null && webhookTrigger.signatureKey != null) {
            equalsBuilder.append((Object)this.signatureKey, (Object)webhookTrigger.signatureKey);
        }
        equalsBuilder.append((Object)this.body, (Object)webhookTrigger.body);
        equalsBuilder.append((Object)this.responseCode, (Object)webhookTrigger.responseCode);
        equalsBuilder.append(this.headers, webhookTrigger.headers);
        return equalsBuilder.isEquals();
    }

    public WebhookTrigger clone() {
        try {
            WebhookTrigger trigger = (WebhookTrigger)super.clone();
            trigger.headers = new ArrayList<WebhookTriggerHeader>();
            if (this.headers != null) {
                trigger.headers.addAll(this.headers);
            }
            return trigger;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.httpVerb == null ? 0 : this.httpVerb.hashCode());
        hash = 31 * hash + (this.signatureKey == null ? 0 : this.signatureKey.hashCode());
        hash = 31 * hash + (this.accessKey == null ? 0 : this.accessKey.hashCode());
        hash = 31 * hash + (this.body == null ? 0 : this.body.hashCode());
        hash = 31 * hash + (this.responseCode == null ? 0 : this.responseCode.hashCode());
        hash = 31 * hash + (this.headers == null ? 0 : this.headers.hashCode());
        return hash;
    }
}

