/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.smtp;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRule;
import com.nuix.automate.utils.models.api.smtp.EmailState;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.InitiatorType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class SmtpEmail
extends UserPermissionModel {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SmtpEmail.class);
    private String id;
    private String initiatorId;
    private String smtpServerId;
    private String submittedUserId;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String subject;
    private String message;
    private Set<String> additionalAttachments;
    private String reportFilePath;
    private String workflowLog;
    private Boolean htmlFormat;
    private Long createdDate;
    private Long sentDate;
    private EmailState state;
    private EmailType type;
    private InitiatorType initiatorType;
    private int attempts;
    private Status status;

    public SmtpEmail() {
    }

    public SmtpEmail(LegalHold legalHold) {
        this(legalHold.getId(), legalHold.getSmtpServerId());
        this.initiatorType = InitiatorType.LEGAL_HOLD;
    }

    public SmtpEmail(EmailNotificationRule notificationRule) {
        this(notificationRule.getId(), notificationRule.getSmtpServiceId());
        this.initiatorType = InitiatorType.NOTIFICATION_RULE;
    }

    public SmtpEmail(String initiatorId, String smtpServerId) {
        this.id = UidUtils.getRandom();
        this.initiatorId = initiatorId;
        this.smtpServerId = smtpServerId;
        this.state = EmailState.PENDING;
        this.createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.attempts = 0;
    }

    @Override
    public SmtpEmail clone() {
        return (SmtpEmail)super.clone();
    }

    public String buildTemplateHtmlMessage(String submittedBy, String description, String viewLink) {
        try {
            String resourceName = "/templates/smtpEmailTestMessage.html";
            InputStream stream = SmtpEmail.class.getResourceAsStream(resourceName);
            if (stream == null) {
                throw new IllegalStateException("Missing template SMTP email message: " + resourceName);
            }
            String messageHtml = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm z").withZone(ZoneId.of("UTC"));
            messageHtml = messageHtml.replace("{email_type}", FormattingUtils.encodeForHtml(this.getType().toString()));
            messageHtml = messageHtml.replace("{created_date}", FormattingUtils.encodeForHtml(dateTimeFormatter.format(Instant.ofEpochMilli(this.getCreatedDate()))));
            if (submittedBy != null) {
                messageHtml = messageHtml.replace("{created_by}", FormattingUtils.encodeForHtml(submittedBy));
            }
            if (description != null) {
                messageHtml = messageHtml.replace("{email_description}", FormattingUtils.encodeForHtml(description));
            }
            if (viewLink != null) {
                messageHtml = messageHtml.replace("{view_link}", FormattingUtils.encodeForUriQuotes(viewLink));
            }
            Document messageDoc = Jsoup.parse((String)messageHtml);
            Element createdByElement = messageDoc.getElementById("created-by-row");
            if (submittedBy == null && createdByElement != null) {
                createdByElement.remove();
            }
            Element descriptionElement = messageDoc.getElementById("email-description");
            if (description == null && descriptionElement != null) {
                descriptionElement.remove();
            }
            Element viewLinkElement = messageDoc.getElementById("view-link");
            if (viewLink == null && viewLinkElement != null) {
                viewLinkElement.remove();
            }
            return messageDoc.toString();
        }
        catch (IOException e) {
            LOGGER.error("Error building templateHtmlMessage: ", e);
            if (viewLink != null) {
                return "<a href='" + FormattingUtils.encodeForUrl(viewLink) + "'>" + FormattingUtils.encodeForHtml(viewLink) + "</a>";
            }
            return "";
        }
    }

    public int incrementAttempts() {
        return ++this.attempts;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getSmtpServerId() {
        return this.smtpServerId;
    }

    public String getSubmittedUserId() {
        return this.submittedUserId;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<String> getAdditionalAttachments() {
        return this.additionalAttachments;
    }

    public String getReportFilePath() {
        return this.reportFilePath;
    }

    public String getWorkflowLog() {
        return this.workflowLog;
    }

    public Boolean getHtmlFormat() {
        return this.htmlFormat;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getSentDate() {
        return this.sentDate;
    }

    public EmailState getState() {
        return this.state;
    }

    public EmailType getType() {
        return this.type;
    }

    public InitiatorType getInitiatorType() {
        return this.initiatorType;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInitiatorId(String initiatorId) {
        this.initiatorId = initiatorId;
    }

    public void setSmtpServerId(String smtpServerId) {
        this.smtpServerId = smtpServerId;
    }

    public void setSubmittedUserId(String submittedUserId) {
        this.submittedUserId = submittedUserId;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setAdditionalAttachments(Set<String> additionalAttachments) {
        this.additionalAttachments = additionalAttachments;
    }

    public void setReportFilePath(String reportFilePath) {
        this.reportFilePath = reportFilePath;
    }

    public void setWorkflowLog(String workflowLog) {
        this.workflowLog = workflowLog;
    }

    public void setHtmlFormat(Boolean htmlFormat) {
        this.htmlFormat = htmlFormat;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public void setSentDate(Long sentDate) {
        this.sentDate = sentDate;
    }

    public void setState(EmailState state) {
        this.state = state;
    }

    public void setType(EmailType type) {
        this.type = type;
    }

    public void setInitiatorType(InitiatorType initiatorType) {
        this.initiatorType = initiatorType;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }
}

