/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.EccUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

public class EccService
extends ThirdPartyService {
    @Schema(description="Host name", example="https://ecc.local:8081/")
    public String url;

    public EccService() {
    }

    public EccService(String url) {
        this.url = url;
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        EccService eccService = (EccService)thirdPartyService;
        if (eccService.getUrl() != null) {
            this.setUrl(eccService.getUrl());
        }
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new EccUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{ecc_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.ECC_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Nuix ECC Service";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

