/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.models.api.thirdparty.ElasticsearchUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ElasticsearchService
extends ThirdPartyService {
    @Schema(description="Elastic Properties")
    public Map<String, String> elasticProperties;

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new ElasticsearchUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{elasticsearch_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.ELASTICSEARCH_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.NONE, ThirdPartyAuthenticationMethod.SECRET_PROPERTIES);
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (this.elasticProperties != null) {
            for (String key : this.elasticProperties.keySet()) {
                if (!key.endsWith("password") && !key.endsWith("passphrase")) continue;
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("CannotSetPasswordsInProperties"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        ElasticsearchService service = (ElasticsearchService)thirdPartyService;
        if (service.getElasticProperties() != null) {
            String newHost;
            String previousHost = "";
            if (this.elasticProperties != null) {
                previousHost = "" + this.elasticProperties.get("nuix.transport.hosts") + "," + this.elasticProperties.get("nuix.http.hosts");
            }
            if (!(newHost = "" + service.getElasticProperties().get("nuix.transport.hosts") + "," + service.getElasticProperties().get("nuix.http.hosts")).equals(previousHost)) {
                userCredentialStale = true;
            }
            this.setElasticProperties(service.getElasticProperties());
        }
        return userCredentialStale;
    }

    @Override
    public ThirdPartyService cloneLimited() {
        ElasticsearchService limited = new ElasticsearchService();
        limited.applyLimitedSettingsFrom(this);
        HashMap<String, String> elasticPropertiesCopy = new HashMap<String, String>();
        if (this.elasticProperties != null) {
            elasticPropertiesCopy.putAll(this.elasticProperties);
        }
        limited.setElasticProperties(elasticPropertiesCopy);
        return limited;
    }

    @Override
    public void normalize() {
        if (this.elasticProperties != null) {
            TreeMap<String, String> normalizedProperties = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : this.elasticProperties.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                normalizedProperties.put(entry.getKey(), entry.getValue());
            }
            this.elasticProperties = normalizedProperties;
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "ElasticSearch";
    }

    public Map<String, String> getElasticProperties() {
        return this.elasticProperties;
    }

    public void setElasticProperties(Map<String, String> elasticProperties) {
        this.elasticProperties = elasticProperties;
    }
}

