/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.genai.GenAiProtocol;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GenAiService
extends ThirdPartyService {
    @Schema(description="URL", example="https://api.openai.com")
    private String url;
    @Schema(description="Model", example="gpt-3.5-turbo")
    private String model;
    @Schema(description="Enable Model Override", example="true")
    private Boolean enableModelOverride;
    @Schema(description="Use System Role", example="true")
    private Boolean enableSystemRole;
    @Schema(description="Detect Context Window", example="true")
    private Boolean detectContextWindow;
    @Schema(description="Context Window", example="128000")
    private Integer contextWindow;
    @Schema(description="Custom Parameters")
    public Map<String, String> customParameters;
    @Schema(description="Protocol")
    private GenAiProtocol protocol;
    @Schema(description="Multi-threading", example="1")
    private Integer multiThreading;
    @Schema(description="Timeout (s)", example="60")
    private Integer timeoutS;
    @Schema(description="Max retries", example="3")
    private Integer maxRetries;

    public GenAiService() {
    }

    public GenAiService(String hostname) {
        this.url = hostname;
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new GenAiUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{gen_ai_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.GEN_AI_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.API_KEY, ThirdPartyAuthenticationMethod.BEARER_TOKEN, ThirdPartyAuthenticationMethod.CUSTOM_HEADER, ThirdPartyAuthenticationMethod.USERNAME_PASSWORD, ThirdPartyAuthenticationMethod.NONE);
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        GenAiService genAiService = (GenAiService)thirdPartyService;
        if (genAiService.getModel() != null) {
            this.setModel(genAiService.getModel());
        }
        if (genAiService.getEnableModelOverride() != null) {
            this.setEnableModelOverride(genAiService.getEnableModelOverride());
        }
        if (genAiService.getEnableSystemRole() != null) {
            this.setEnableSystemRole(genAiService.getEnableSystemRole());
        }
        if (genAiService.getDetectContextWindow() != null) {
            this.setDetectContextWindow(genAiService.getDetectContextWindow());
        }
        if (genAiService.getContextWindow() != null) {
            this.setContextWindow(genAiService.getContextWindow());
        }
        if (genAiService.getProtocol() != null) {
            this.setProtocol(genAiService.getProtocol());
        }
        if (genAiService.getMultiThreading() != null) {
            this.setMultiThreading(genAiService.getMultiThreading());
        }
        if (genAiService.getTimeoutS() != null) {
            this.setTimeoutS(genAiService.getTimeoutS());
        }
        if (genAiService.getMaxRetries() != null) {
            this.setMaxRetries(genAiService.getMaxRetries());
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        GenAiService genAiService = (GenAiService)thirdPartyService;
        if (genAiService.getCustomParameters() != null) {
            this.setCustomParameters(genAiService.getCustomParameters());
        }
        if (genAiService.getUrl() != null) {
            userCredentialStale = userCredentialStale || !genAiService.getUrl().equals(this.url);
            this.setUrl(genAiService.getUrl());
        }
        return userCredentialStale;
    }

    @Override
    public ThirdPartyService cloneLimited() {
        GenAiService limited = new GenAiService();
        limited.applyLimitedSettingsFrom(this);
        if (this.enableModelOverride != null) {
            limited.setEnableModelOverride(this.enableModelOverride);
        }
        if (this.enableSystemRole != null) {
            limited.setEnableSystemRole(this.enableSystemRole);
        }
        HashMap<String, String> customParametersCopy = new HashMap<String, String>();
        if (this.customParameters != null) {
            customParametersCopy.putAll(this.customParameters);
        }
        if (this.multiThreading != null) {
            limited.setMultiThreading(this.multiThreading);
        }
        if (this.maxRetries != null) {
            limited.setMaxRetries(this.maxRetries);
        }
        if (this.timeoutS != null) {
            limited.setTimeoutS(this.timeoutS);
        }
        if (this.protocol != null) {
            limited.setProtocol(this.protocol);
        }
        limited.setCustomParameters(customParametersCopy);
        return limited;
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        ThirdPartyUserCredential userCredential = this.getUserCredential();
        if (this.getAuthenticationMethod() != null && this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.NONE) && userCredential != null) {
            userCredential.setToken("");
            userCredential.setPassword("");
            userCredential.setUsername("");
        }
        if (this.customParameters != null) {
            TreeMap<String, String> normalizedProperties = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                normalizedProperties.put(entry.getKey(), entry.getValue());
            }
            this.customParameters = normalizedProperties;
        } else {
            this.customParameters = new TreeMap<String, String>();
        }
        if (this.multiThreading == null || this.multiThreading < 1) {
            this.multiThreading = 1;
        }
        if (this.maxRetries == null) {
            this.maxRetries = 3;
        }
        if (this.timeoutS == null) {
            this.timeoutS = 60;
        }
        if (this.detectContextWindow == null) {
            this.detectContextWindow = true;
        }
        if (this.contextWindow == null) {
            this.contextWindow = 1000;
        }
        if (this.enableModelOverride == null) {
            this.enableModelOverride = false;
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Gen AI";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Boolean getEnableModelOverride() {
        return this.enableModelOverride;
    }

    public void setEnableModelOverride(Boolean enableModelOverride) {
        this.enableModelOverride = enableModelOverride;
    }

    public Boolean getEnableSystemRole() {
        return this.enableSystemRole;
    }

    public void setEnableSystemRole(Boolean enableSystemRole) {
        this.enableSystemRole = enableSystemRole;
    }

    public Boolean getDetectContextWindow() {
        return this.detectContextWindow;
    }

    public void setDetectContextWindow(Boolean detectContextWindow) {
        this.detectContextWindow = detectContextWindow;
    }

    public Integer getContextWindow() {
        return this.contextWindow;
    }

    public void setContextWindow(Integer contextWindow) {
        this.contextWindow = contextWindow;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public boolean getAuthenticationRequired() {
        return this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.API_KEY) || this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.BEARER_TOKEN) || this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.USERNAME_PASSWORD) || this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.CUSTOM_HEADER);
    }

    public GenAiProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(GenAiProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public GenAiService clone() {
        GenAiService clone = (GenAiService)super.clone();
        if (this.customParameters != null) {
            HashMap<String, String> customParametersCopy = new HashMap<String, String>(this.customParameters);
            clone.setCustomParameters(customParametersCopy);
        }
        clone.protocol = this.protocol;
        return clone;
    }

    public Integer getMultiThreading() {
        return this.multiThreading;
    }

    public void setMultiThreading(Integer multiThreading) {
        this.multiThreading = multiThreading;
    }

    public Integer getTimeoutS() {
        return this.timeoutS;
    }

    public void setTimeoutS(Integer timeoutS) {
        this.timeoutS = timeoutS;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }
}

