/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.models.api.thirdparty.PurviewUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.security.policies.ApplicationFeatures;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;

public class PurviewService
extends ThirdPartyService {
    @Schema(description="Use Purview Download", example="True")
    private Boolean usePurviewDownload;

    @Override
    public ApplicationFeatures getViewFeature() {
        return ApplicationFeatures.VIEW_PURVIEW_JOBS;
    }

    @Override
    public ApplicationFeatures getAddFeature() {
        return ApplicationFeatures.ADD_PURVIEW_JOB;
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        PurviewService purviewService = (PurviewService)thirdPartyService;
        if (purviewService.getUsePurviewDownload() != null) {
            userCredentialStale = userCredentialStale || !purviewService.getUsePurviewDownload().equals(this.usePurviewDownload);
            this.setUsePurviewDownload(purviewService.getUsePurviewDownload());
        }
        return userCredentialStale;
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new PurviewUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{purview_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.PURVIEW_SERVICE;
    }

    @Override
    public AuthMethodType getOidcAuthMethodType() {
        return AuthMethodType.OIDC_MICROSOFT;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE);
    }

    @Override
    public ThirdPartyService cloneLimited() {
        PurviewService limited = new PurviewService();
        limited.applyLimitedSettingsFrom(this);
        return limited;
    }

    @Override
    public String getPrintableServiceType() {
        return "Microsoft Purview";
    }

    public Boolean getUsePurviewDownload() {
        return this.usePurviewDownload;
    }

    public void setUsePurviewDownload(Boolean usePurviewDownload) {
        this.usePurviewDownload = usePurviewDownload;
    }
}

