/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.webhook;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.InternationalizationUtils;
import io.swagger.v3.oas.annotations.media.Schema;

public class WebhookCall
implements Cloneable {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    @Schema(description="Call ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Call Attempt Number", example="3")
    private int attemptNumber;
    @Schema(description="Response Status Code", example="202")
    private int responseStatus;
    @Schema(description="Request Time (Epoch)", example="1641034800000")
    private Long requestEpoch;
    @Schema(description="Request Headers")
    private String requestHeaders;
    @Schema(description="Response Headers")
    private String responseHeaders;
    @Schema(description="Response Body")
    private String responseBody;
    @Schema(description="Response Time (Epoch)", example="1641034800000")
    private Long responseEpoch;

    public WebhookCall clone() {
        try {
            return (WebhookCall)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static InternationalizationUtils getIu() {
        return iu;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public void setAttemptNumber(int attemptNumber) {
        this.attemptNumber = attemptNumber;
    }

    public Long getRequestEpoch() {
        return this.requestEpoch;
    }

    public void setRequestEpoch(Long requestEpoch) {
        this.requestEpoch = requestEpoch;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public Long getResponseEpoch() {
        return this.responseEpoch;
    }

    public void setResponseEpoch(Long responseEpoch) {
        this.responseEpoch = responseEpoch;
    }

    @JsonIgnore
    public boolean isInProgress() {
        return this.requestEpoch == null || this.responseEpoch == null;
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.responseStatus >= 200 && this.responseStatus <= 299;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

