/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.webhook;

import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.webhook.WebhookCall;
import com.nuix.automate.utils.models.internal.event.EventType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

public class WebhookEvent
implements Cloneable {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    @Schema(description="Event ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Webhook ID", example="11111111-1111-1111-1111-111111111111")
    private String webhookId;
    @Schema(description="Event Trigger Type")
    private EventType.Type triggerType;
    @Schema(description="Event Object Type", example="Job")
    private String objectType;
    @Schema(description="Event Time (Epoch)", example="1641034800000")
    private long epoch;
    @Schema(description="Event Object Body (JSON)")
    private String body;
    @Schema(description="Event Triggered By User", example="jsmith@example.com")
    private String triggeredByUser;
    @Schema(description="Event Status")
    private Status status;
    @Schema(description="Event Calls")
    private List<WebhookCall> calls;

    public WebhookEvent clone() {
        WebhookEvent clone = null;
        try {
            clone = (WebhookEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.calls = new ArrayList<WebhookCall>();
        if (this.calls != null) {
            for (WebhookCall webhookCall : this.calls) {
                clone.calls.add(webhookCall.clone());
            }
        }
        return clone;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getWebhookId() {
        return this.webhookId;
    }

    public void setWebhookId(String webhookId) {
        this.webhookId = webhookId;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<WebhookCall> getCalls() {
        return this.calls;
    }

    public void setCalls(List<WebhookCall> calls) {
        this.calls = calls;
    }

    public void setTriggerType(EventType.Type triggerType) {
        this.triggerType = triggerType;
    }

    public EventType.Type getTriggerType() {
        return this.triggerType;
    }

    public String getTriggeredByUser() {
        return this.triggeredByUser;
    }

    public void setTriggeredByUser(String triggeredByUser) {
        this.triggeredByUser = triggeredByUser;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }
}

