/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.cache;

import com.nuix.automate.utils.models.internal.cache.CachedObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CachedObjectMap<T> {
    private final Map<String, CachedObject<T>> cachedObjectMap = new ConcurrentHashMap<String, CachedObject<T>>();
    private Integer limit;
    private int clearInterval;
    private long lastClearMillis;
    private long expireInMs;

    public CachedObjectMap(long expireInMs, Integer limit) {
        this.limit = limit;
        this.clearInterval = 30;
        this.expireInMs = expireInMs;
    }

    public CachedObjectMap(long expireInMs) {
        this(expireInMs, null);
    }

    public CachedObjectMap() {
        this(10000L);
    }

    public T get(String key) {
        return this.get(key, false);
    }

    public T get(String key, boolean resetExpiry) {
        CachedObject<T> cachedObject = this.cachedObjectMap.get(key);
        if (cachedObject == null) {
            return null;
        }
        if (resetExpiry) {
            cachedObject.resetExpiry();
        } else if (cachedObject.isExpired()) {
            return null;
        }
        return cachedObject.getObject();
    }

    public CachedObject<T> put(T object) {
        return this.put((String)object, object);
    }

    public CachedObject<T> put(String key, T object) {
        this.trim();
        return this.cachedObjectMap.put(key, new CachedObject<T>(object, this.expireInMs));
    }

    public void remove(String key) {
        if (key != null) {
            this.cachedObjectMap.remove(key);
        }
    }

    public void resetExpiry(String key) {
        if (key != null && this.cachedObjectMap.containsKey(key)) {
            this.cachedObjectMap.get(key).resetExpiry();
        }
    }

    public void clearExpired() {
        this.cachedObjectMap.values().removeIf(CachedObject::isExpired);
    }

    public void clear() {
        this.cachedObjectMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim() {
        if (this.limit != null && this.cachedObjectMap.size() >= this.limit && DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() > this.lastClearMillis + (long)this.clearInterval * 1000L) {
            this.lastClearMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            CachedObjectMap cachedObjectMap = this;
            synchronized (cachedObjectMap) {
                ArrayList<Map.Entry<String, CachedObject<T>>> cacheEntries = new ArrayList<Map.Entry<String, CachedObject<T>>>(this.cachedObjectMap.entrySet());
                cacheEntries.sort((e1, e2) -> Long.compare(((CachedObject)e2.getValue()).getExpirationMs(), ((CachedObject)e1.getValue()).getExpirationMs()));
                for (int i = 0; i < cacheEntries.size(); ++i) {
                    if (!((double)i > (double)this.limit.intValue() * 0.9) && !cacheEntries.get(i).getValue().isExpired()) continue;
                    this.cachedObjectMap.remove(cacheEntries.get(i).getKey());
                }
            }
        }
    }

    public T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return this.cachedObjectMap.computeIfAbsent(key, (? super K k) -> new CachedObject(mappingFunction.apply((String)k), this.expireInMs)).getObject();
    }

    public void setExpireInMs(long expireInMs) {
        this.expireInMs = expireInMs;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setClearInterval(int clearInterval) {
        this.clearInterval = clearInterval;
    }

    public Map<String, CachedObject<T>> getUnderlyingMap() {
        return this.cachedObjectMap;
    }
}

