/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.dataset;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

public class UsableSpace
implements Serializable {
    @Schema(description="File System Usable Space (Bytes)", example="52147483647")
    private Long fileSystemUsableSpace;
    @Schema(description="Quota Usable Space (Bytes)", example="52147483647")
    private Long quotaUsableSpace;

    public UsableSpace() {
        this(0L, 0L);
    }

    public UsableSpace(Long usableDiskSpace, Long quotaUsableSpace) {
        this.fileSystemUsableSpace = usableDiskSpace;
        this.quotaUsableSpace = quotaUsableSpace;
    }

    public UsableSpace(UsableSpace repositoryUsableSpace) {
        this.fileSystemUsableSpace = repositoryUsableSpace.fileSystemUsableSpace;
        this.quotaUsableSpace = repositoryUsableSpace.quotaUsableSpace;
    }

    @Schema(description="Effective Usable Space (Bytes)", example="52147483647")
    public Long getEffectiveUsableSpace() {
        Long effectiveSpaceAvailable = this.fileSystemUsableSpace == null ? this.quotaUsableSpace : (this.quotaUsableSpace == null ? this.fileSystemUsableSpace : Long.valueOf(Math.min(this.fileSystemUsableSpace, this.quotaUsableSpace)));
        if (effectiveSpaceAvailable != null) {
            return Math.max(0L, effectiveSpaceAvailable);
        }
        return effectiveSpaceAvailable;
    }

    public void takeSpace(long size) {
        if (this.fileSystemUsableSpace != null) {
            this.fileSystemUsableSpace = this.fileSystemUsableSpace - size;
        }
        if (this.quotaUsableSpace != null) {
            this.quotaUsableSpace = this.quotaUsableSpace - size;
        }
    }

    public Long getFileSystemUsableSpace() {
        return this.fileSystemUsableSpace;
    }

    public void setFileSystemUsableSpace(Long fileSystemUsableSpace) {
        this.fileSystemUsableSpace = fileSystemUsableSpace;
    }

    public Long getQuotaUsableSpace() {
        return this.quotaUsableSpace;
    }

    public void setQuotaUsableSpace(Long quotaUsableSpace) {
        this.quotaUsableSpace = quotaUsableSpace;
    }
}

