/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.nuix.automate.utils.api.automatelicense.AutomateLicence;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.models.api.apikey.ApiKey;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.comment.UserComment;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import com.nuix.automate.utils.models.api.engine.Engine;
import com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.JobErrors;
import com.nuix.automate.utils.models.api.job.JobId;
import com.nuix.automate.utils.models.api.job.JobInfos;
import com.nuix.automate.utils.models.api.job.JobOperationId;
import com.nuix.automate.utils.models.api.job.JobSoftErrors;
import com.nuix.automate.utils.models.api.job.JobWarnings;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipations;
import com.nuix.automate.utils.models.api.notice.NoticeComment;
import com.nuix.automate.utils.models.api.notice.UserNotice;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.nuixlicensesource.NuixLicenseSource;
import com.nuix.automate.utils.models.api.resourcepool.ResourcePool;
import com.nuix.automate.utils.models.api.schedule.Run;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.service.ServiceInfo;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.user.LoginAttempt;
import com.nuix.automate.utils.models.api.user.LoginFailure;
import com.nuix.automate.utils.models.api.user.Logout;
import com.nuix.automate.utils.models.api.userdatadir.UserDataDir;
import com.nuix.automate.utils.models.api.utilization.ImportResults;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.persistance.EventTypeDeserializer;
import com.nuix.automate.utils.persistance.EventTypeSerializer;

@JsonSerialize(using=EventTypeSerializer.class)
@JsonDeserialize(using=EventTypeDeserializer.class)
public class EventType {
    private static final String legacyEventPrefix = "PROCESSING_";
    private Type type;
    private String legacyType;

    public EventType(Type type) {
        this.type = type;
    }

    private EventType(String legacyType) {
        this.type = Type.LEGACY_EVENT;
        this.legacyType = legacyType;
    }

    public String toString() {
        if (this.type.equals((Object)Type.LEGACY_EVENT)) {
            return this.legacyType;
        }
        return this.type.name();
    }

    public static EventType fromString(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith(legacyEventPrefix)) {
            s = s.substring(legacyEventPrefix.length());
        }
        for (Type candidate : Type.values()) {
            if (!candidate.name().equals(s)) continue;
            return new EventType(candidate);
        }
        return new EventType(s);
    }

    public Type getType() {
        return this.type;
    }

    public Kind getKind() {
        return this.type.getKind();
    }

    @JsonCreator
    public static EventType getContainerFromValue(String value) throws JsonMappingException {
        return EventType.fromString(value);
    }

    public static enum Type {
        JOB_SUBMITTED(Kind.JOB, Job.class),
        JOB_ADDED_TO_STAGING(Kind.JOB, Job.class),
        JOB_MODIFIED(Kind.JOB, Job.class),
        JOB_RESUBMITTED(Kind.JOB, Job.class),
        JOB_ARCHIVED(Kind.JOB, Job.class),
        JOB_SUBMITTED_FROM_STAGING(Kind.JOB, Job.class),
        JOB_MOVED_TO_STAGING(Kind.JOB, Job.class),
        JOB_STARTED(Kind.JOB, Job.class),
        JOB_RESUMED(Kind.JOB, Job.class),
        JOB_PAUSED(Kind.JOB, Job.class),
        JOB_ENDED(Kind.JOB, Job.class),
        JOB_CANCELED(Kind.JOB, Job.class),
        JOB_INFO(Kind.JOB, JobInfos.class),
        JOB_WARNING(Kind.JOB, JobWarnings.class),
        JOB_SOFT_ERROR(Kind.JOB, JobSoftErrors.class),
        JOB_ERROR(Kind.JOB, JobErrors.class),
        JOB_COMMAND_ERROR(Kind.JOB, JobErrors.class),
        JOB_OPERATION_STARTED(Kind.JOB, OperationStatus.class),
        JOB_OPERATION_SKIPPED(Kind.JOB, OperationStatus.class),
        JOB_OPERATION_ENDED(Kind.JOB, OperationStatus.class),
        JOB_OPERATION_WARNING(Kind.JOB, OperationStatus.class),
        JOB_OPERATION_ERROR(Kind.JOB, OperationStatus.class),
        JOB_OPERATION_SOFT_ERROR(Kind.JOB, OperationStatus.class),
        JOB_METRICS_EXCLUDED(Kind.JOB, Job.class),
        JOB_METRICS_REINCLUDED(Kind.JOB, Job.class),
        JOB_CANCEL_REQUESTED(Kind.JOB, JobId.class),
        JOB_PAUSE_REQUESTED(Kind.JOB, JobId.class),
        JOB_STOP_REQUESTED(Kind.JOB, JobId.class),
        JOB_ABORT_REQUESTED(Kind.JOB, JobId.class),
        JOB_OPERATION_SKIP_REQUESTED(Kind.JOB, JobOperationId.class),
        SCHEDULE_ADDED(Kind.SCHEDULE, Schedule.class),
        SCHEDULE_DELETED(Kind.SCHEDULE, Schedule.class),
        SCHEDULE_MODIFIED(Kind.SCHEDULE, Schedule.class),
        SCHEDULE_TRIGGERED(Kind.SCHEDULE, Run.class),
        FILE_LIBRARY_ADDED(Kind.FILE_LIBRARY, FileLibrary.class),
        FILE_LIBRARY_MODIFIED(Kind.FILE_LIBRARY, FileLibrary.class),
        FILE_LIBRARY_DELETED(Kind.FILE_LIBRARY, FileLibrary.class),
        FILE_LIBRARY_FILE_ADDED(Kind.FILE_LIBRARY, FileLibraryFile.class),
        FILE_LIBRARY_FILE_MODIFIED(Kind.FILE_LIBRARY, FileLibraryFile.class),
        FILE_LIBRARY_FILE_DELETED(Kind.FILE_LIBRARY, FileLibraryFile.class),
        LEGAL_HOLD_ADDED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_DELETED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_MODIFIED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_ACTIVATED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_RELEASED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_ARCHIVED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_PARTICIPATION_CHANGED(Kind.LEGAL_HOLD, LegalHold.class),
        LEGAL_HOLD_CUSTODIANS_ADDED(Kind.LEGAL_HOLD, LegalHoldParticipations.class),
        LEGAL_HOLD_CUSTODIANS_ISSUED_HOLD(Kind.LEGAL_HOLD, LegalHoldParticipations.class),
        LEGAL_HOLD_CUSTODIANS_RELEASED(Kind.LEGAL_HOLD, LegalHoldParticipations.class),
        LEGAL_HOLD_CUSTODIANS_REMOVED(Kind.LEGAL_HOLD, LegalHoldParticipations.class),
        LEGAL_HOLD_NOTICE_CUSTODIAN_RESPONDED(Kind.LEGAL_HOLD, UserNotice.class),
        LEGAL_HOLD_NOTICE_CUSTODIAN_ADDED_COMMENT(Kind.LEGAL_HOLD, NoticeComment.class),
        LEGAL_HOLD_NOTICE_ADMIN_ADDED_COMMENT(Kind.LEGAL_HOLD, NoticeComment.class),
        LEGAL_HOLD_NOTICE_ADMIN_ADDED_ADMIN_NOTE(Kind.LEGAL_HOLD, NoticeComment.class),
        LEGAL_HOLD_NOTICE_REMINDER(Kind.LEGAL_HOLD, UserNotice.class),
        LEGAL_HOLD_NOTICE_ESCALATION(Kind.LEGAL_HOLD, UserNotice.class),
        LEGAL_HOLD_NOTICE_RECURRING(Kind.LEGAL_HOLD, UserNotice.class),
        JOB_USER_COMMENT_ADDED(Kind.JOB, UserComment.class),
        CLIENT_POOL_ADDED(Kind.CLIENT_POOL, ClientPool.class),
        CLIENT_POOL_DELETED(Kind.CLIENT_POOL, ClientPool.class),
        CLIENT_POOL_MODIFIED(Kind.CLIENT_POOL, ClientPool.class),
        CLIENT_ADDED(Kind.CLIENT, Client.class),
        CLIENT_DELETED(Kind.CLIENT, Client.class),
        CLIENT_MODIFIED(Kind.CLIENT, Client.class),
        MATTER_ADDED(Kind.MATTER, Matter.class),
        MATTER_DELETED(Kind.MATTER, Matter.class),
        MATTER_MODIFIED(Kind.MATTER, Matter.class),
        DATA_REPOSITORY_ADDED(Kind.DATA_REPOSITORY, DataRepository.class),
        DATA_REPOSITORY_DELETED(Kind.DATA_REPOSITORY, DataRepository.class),
        DATA_REPOSITORY_MODIFIED(Kind.DATA_REPOSITORY, DataRepository.class),
        DATA_SET_ADDED(Kind.DATA_SET, Dataset.class),
        DATA_SET_DELETED(Kind.DATA_SET, Dataset.class),
        DATA_SET_ERROR(Kind.DATA_SET, Dataset.class),
        DATA_SET_FINALIZED(Kind.DATA_SET, Dataset.class),
        DATA_SET_HIDDEN(Kind.DATA_SET, Dataset.class),
        DATA_SET_UNHIDDEN(Kind.DATA_SET, Dataset.class),
        DATA_SET_ARCHIVED(Kind.DATA_SET, Dataset.class),
        DATA_SET_UNARCHIVED(Kind.DATA_SET, Dataset.class),
        DATA_SET_EXPIRED(Kind.DATA_SET, Dataset.class),
        DATA_SET_FILE_UPLOADED(Kind.DATA_SET_FILE, FileInfo.class),
        DATA_SET_FILE_OVERWROTE(Kind.DATA_SET_FILE, FileInfo.class),
        DATA_SET_FILE_DELETED(Kind.DATA_SET_FILE, FileInfo.class),
        DATA_SET_FILE_METADATA_UPDATED(Kind.DATA_SET_FILE, FileInfo.class),
        LIBRARY_ADDED(Kind.LIBRARY, WorkflowLibrary.class),
        LIBRARY_DELETED(Kind.LIBRARY, WorkflowLibrary.class),
        LIBRARY_MODIFIED(Kind.LIBRARY, WorkflowLibrary.class),
        WORKFLOW_ADDED(Kind.WORKFLOW, Workflow.class),
        WORKFLOW_DELETED(Kind.WORKFLOW, Workflow.class),
        WORKFLOW_MODIFIED(Kind.WORKFLOW, Workflow.class),
        AUTOMATE_LICENSE_UPDATED(Kind.AUTOMATE_LICENSE, AutomateLicence.class),
        AUTOMATE_LICENSE_WARNING(Kind.AUTOMATE_LICENSE, AutomateLicence.class),
        AUTOMATE_LICENSE_ERROR(Kind.AUTOMATE_LICENSE, AutomateLicence.class),
        NETWORK_CONFIGURATION_UPDATED(Kind.NETWORK_CONFIGURATION, NetworkConfiguration.class),
        NETWORK_CONFIGURATION_CLEARED(Kind.NETWORK_CONFIGURATION, NetworkConfiguration.class),
        USER_DATA_DIR_UPDATED(Kind.USER_DATA_DIR, UserDataDir.class),
        USER_DATA_DIR_REMOVED(Kind.USER_DATA_DIR, UserDataDir.class),
        NUIX_LICENSE_SOURCE_ADDED(Kind.NUIX_LICENSE_SOURCE, NuixLicenseSource.class),
        NUIX_LICENSE_SOURCE_DELETED(Kind.NUIX_LICENSE_SOURCE, NuixLicenseSource.class),
        NUIX_LICENSE_SOURCE_MODIFIED(Kind.NUIX_LICENSE_SOURCE, NuixLicenseSource.class),
        NUIX_LICENSE_SOURCE_ERROR(Kind.NUIX_LICENSE_SOURCE, NuixLicenseSource.class),
        ENGINE_SERVER_ADDED(Kind.ENGINE_SERVER, Server.class),
        ENGINE_SERVER_DELETED(Kind.ENGINE_SERVER, Server.class),
        ENGINE_SERVER_MODIFIED(Kind.ENGINE_SERVER, Server.class),
        ENGINE_SERVER_ERROR(Kind.ENGINE_SERVER, Server.class),
        ENGINE_ADDED(Kind.ENGINE, Engine.class),
        ENGINE_DELETED(Kind.ENGINE, Engine.class),
        ENGINE_MODIFIED(Kind.ENGINE, Engine.class),
        ENGINE_ERROR(Kind.ENGINE, Engine.class),
        ENGINE_LICENSE_ERROR(Kind.ENGINE, Engine.class),
        RESOURCE_POOL_ADDED(Kind.RESOURCE_POOL, ResourcePool.class),
        RESOURCE_POOL_DELETED(Kind.RESOURCE_POOL, ResourcePool.class),
        RESOURCE_POOL_MODIFIED(Kind.RESOURCE_POOL, ResourcePool.class),
        RESOURCE_POOL_ERROR(Kind.RESOURCE_POOL, ResourcePool.class),
        EXECUTION_PROFILE_ADDED(Kind.EXECUTION_PROFILE, ExecutionProfile.class),
        EXECUTION_PROFILE_DELETED(Kind.EXECUTION_PROFILE, ExecutionProfile.class),
        EXECUTION_PROFILE_MODIFIED(Kind.EXECUTION_PROFILE, ExecutionProfile.class),
        NOTIFICATION_RULE_ADDED(Kind.NOTIFICATION_RULE, NotificationRule.class),
        NOTIFICATION_RULE_DELETED(Kind.NOTIFICATION_RULE, NotificationRule.class),
        NOTIFICATION_RULE_MODIFIED(Kind.NOTIFICATION_RULE, NotificationRule.class),
        THIRD_PARTY_SERVICE_ADDED(Kind.THIRD_PARTY_SERVICE, ThirdPartyService.class),
        THIRD_PARTY_SERVICE_DELETED(Kind.THIRD_PARTY_SERVICE, ThirdPartyService.class),
        THIRD_PARTY_SERVICE_MODIFIED(Kind.THIRD_PARTY_SERVICE, ThirdPartyService.class),
        THIRD_PARTY_USER_CREDENTIALS_ADDED(Kind.THIRD_PARTY_USER_CREDENTIAL, ThirdPartyUserCredential.class),
        THIRD_PARTY_USER_CREDENTIALS_DELETED(Kind.THIRD_PARTY_USER_CREDENTIAL, ThirdPartyUserCredential.class),
        THIRD_PARTY_USER_CREDENTIALS_MODIFIED(Kind.THIRD_PARTY_USER_CREDENTIAL, ThirdPartyUserCredential.class),
        SECURITY_POLICY_ADDED(Kind.SECURITY_POLICY, SecurityPolicy.class),
        SECURITY_POLICY_DELETED(Kind.SECURITY_POLICY, SecurityPolicy.class),
        SECURITY_POLICY_MODIFIED(Kind.SECURITY_POLICY, SecurityPolicy.class),
        API_KEY_ADDED(Kind.API_KEY, ApiKey.class),
        API_KEY_DELETED(Kind.API_KEY, ApiKey.class),
        API_KEY_UPDATE_LAST_USED_DAY(Kind.API_KEY, ApiKey.class),
        WEBHOOK_ADDED(Kind.WEBHOOK, Webhook.class),
        WEBHOOK_DELETED(Kind.WEBHOOK, Webhook.class),
        WEBHOOK_MODIFIED(Kind.WEBHOOK, Webhook.class),
        UTILIZATION_LOADED_EXTERNAL(Kind.UTILIZATION, ImportResults.class),
        AUTH_LOGIN_ATTEMPTED(Kind.AUTH, LoginAttempt.class),
        AUTH_LOGIN_SUCCESSFUL(Kind.AUTH, LoginAttempt.class),
        AUTH_LOGIN_FAILED(Kind.AUTH, LoginFailure.class),
        AUTH_LOGOUT(Kind.AUTH, Logout.class),
        SERVICE_AUDIT_LOG_STARTED(Kind.SERVICE, ServiceInfo.class),
        SERVICE_SCHEDULER_STARTED(Kind.SERVICE, ServiceInfo.class),
        SERVICE_SCHEDULER_STOPPED(Kind.SERVICE, ServiceInfo.class),
        LEGACY_EVENT(Kind.LEGACY, Object.class);

        private Kind kind;
        private Class eventClass;

        private Type(Kind kind, Class eventClass) {
            this.kind = kind;
            this.eventClass = eventClass;
        }

        public Kind getKind() {
            return this.kind;
        }

        public Class getEventClass() {
            return this.eventClass;
        }

        public static Type fromString(String s) {
            if (s == null) {
                return null;
            }
            if (s.startsWith(EventType.legacyEventPrefix)) {
                s = s.substring(EventType.legacyEventPrefix.length());
            }
            for (Type candidate : Type.values()) {
                if (!candidate.name().equals(s)) continue;
                return candidate;
            }
            return LEGACY_EVENT;
        }

        @JsonCreator
        public static Type getContainerFromValue(String value) throws JsonMappingException {
            return Type.fromString(value);
        }
    }

    public static enum Kind {
        JOB,
        SCHEDULE,
        LEGAL_HOLD,
        LEGAL_HOLD_NOTICE,
        CLIENT,
        MATTER,
        DATA_REPOSITORY,
        DATA_SET,
        DATA_SET_FILE,
        LIBRARY,
        WORKFLOW,
        AUTOMATE_LICENSE,
        NETWORK_CONFIGURATION,
        USER_DATA_DIR,
        FILE_LIBRARY,
        NUIX_LICENSE_SOURCE,
        ENGINE_SERVER,
        ENGINE,
        RESOURCE_POOL,
        EXECUTION_PROFILE,
        CLIENT_POOL,
        NOTIFICATION_RULE,
        THIRD_PARTY_SERVICE,
        THIRD_PARTY_USER_CREDENTIAL,
        SECURITY_POLICY,
        API_KEY,
        WEBHOOK,
        UTILIZATION,
        AUTH,
        SERVICE,
        USER_COMMENT,
        LEGACY;

    }
}

