/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.executionprofile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.models.api.executionprofile.JobProgressSettings;
import com.nuix.automate.utils.models.api.executionprofile.JobTimeoutSettings;
import com.nuix.automate.utils.models.internal.executionprofile.WorkerTempFolder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecutionProfileModel
extends UserPermissionModel
implements Serializable,
Cloneable {
    public static final String UPDATE_V1 = "UPDATE_V1";
    @Schema(description="Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Execution Profile Name", example="Default Profile")
    private String name;
    @Schema(description="Execution Profile Description", example="2GB memory and standard flags")
    private String description;
    @Schema(description="Engine Account Username", example="EXAMPLE\\serviceaccount")
    private String engineAccountUsername;
    @Schema(description="Engine Account Password", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String engineAccountPassword;
    @Schema(description="Engine Command-Line Parameters", example="-Xmx2g -Duser.language=en -Duser.country=US")
    private String engineCommandLineParameters;
    @Schema(description="Workflow parameters", ref="#/components/schemas/ParametersValue")
    private LinkedHashMap<String, String> workflowParameters;
    @Schema(description="Engine Log Folder", example="\\\\Storage\\Logs")
    private String engineLogFolder;
    @Schema(description="Nuix Engine Folder", example="C:\\Program Files\\Nuix\\Nuix Engine")
    private String nuixEngineFolder;
    @Schema(description="Java Folder", example="C:\\Program Files\\AdoptOpenJDK\\jdk-hotspot\\bin")
    private String javaFolder;
    @Schema(description="Notification Rule IDs", example="[\"11111111-1111-1111-1111-111111111111\",\"22222222-2222-2222-2222-222222222222\"]")
    private List<String> notificationRuleIds;
    @Schema(description="Execution Profile Status", example="C:\\Program Files\\Nuix\\Nuix Engine")
    private Status status;
    @Schema(description="Job Progress Settings")
    private JobProgressSettings jobProgressSettings;
    @Schema(description="Job Timeout Settings")
    private JobTimeoutSettings jobTimeoutSettings;
    @Schema(description="Nuix Profiles", ref="#/components/schemas/ProfileIds")
    private Map<String, String> nuixProfiles;
    @Schema(description="Nuix Profiles", ref="#/components/schemas/FileParameterIds")
    private Map<String, String> additionalFiles;
    @Schema(description="Scheduler URL", example="https://automate.example.com")
    private String schedulerUrl;
    @Schema(description="Scheduler Certificate Fingerprint (SHA-512)", example="e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24")
    private String schedulerCertFingeprint;
    @Schema(description="Worker Temp Folder", example="C:\\Temp\\Nuix\\Automate\\Worker")
    private String workerTempFolder;
    private String duplicateReferenceId;
    private String reference;
    private String referenceVersion;
    private boolean readOnly;

    @Override
    public ExecutionProfileModel clone() {
        ExecutionProfileModel clonedObject = (ExecutionProfileModel)super.clone();
        clonedObject.workflowParameters = new LinkedHashMap();
        if (this.workflowParameters != null) {
            clonedObject.workflowParameters.putAll(this.workflowParameters);
        }
        clonedObject.notificationRuleIds = new ArrayList<String>();
        if (this.notificationRuleIds != null) {
            clonedObject.notificationRuleIds.addAll(this.notificationRuleIds);
        }
        clonedObject.nuixProfiles = new LinkedHashMap<String, String>();
        if (this.nuixProfiles != null) {
            clonedObject.nuixProfiles.putAll(this.nuixProfiles);
        }
        clonedObject.additionalFiles = new LinkedHashMap<String, String>();
        if (this.additionalFiles != null) {
            clonedObject.additionalFiles.putAll(this.additionalFiles);
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEngineAccountUsername() {
        return this.engineAccountUsername;
    }

    public void setEngineAccountUsername(String engineAccountUsername) {
        this.engineAccountUsername = engineAccountUsername;
    }

    public String getEngineAccountPassword() {
        return this.engineAccountPassword;
    }

    public void setEngineAccountPassword(String engineAccountPassword) {
        this.engineAccountPassword = engineAccountPassword;
    }

    public String getEngineCommandLineParameters() {
        return this.engineCommandLineParameters;
    }

    public void setEngineCommandLineParameters(String engineCommandLineParameters) {
        this.engineCommandLineParameters = engineCommandLineParameters;
    }

    public LinkedHashMap<String, String> getWorkflowParameters() {
        if (this.workflowParameters != null) {
            return this.workflowParameters;
        }
        return new LinkedHashMap<String, String>();
    }

    public void setWorkflowParameters(LinkedHashMap<String, String> workflowParameters) {
        this.workflowParameters = this.normalizeParameterNamesStrict(workflowParameters);
    }

    private LinkedHashMap<String, String> normalizeParameterNamesStrict(LinkedHashMap<String, String> parameters) {
        LinkedHashMap<String, String> normalizedParameters = new LinkedHashMap<String, String>();
        if (parameters == null) {
            parameters = new LinkedHashMap();
        }
        for (String parameterName : parameters.keySet()) {
            String normalizedParameterName = FormattingUtils.normalizeParameterName(parameterName);
            if (normalizedParameterName.length() <= 2) continue;
            normalizedParameters.put(normalizedParameterName, parameters.get(parameterName));
        }
        return normalizedParameters;
    }

    public Map<String, String> getNuixProfiles() {
        return this.nuixProfiles;
    }

    public void setNuixProfiles(Map<String, String> nuixProfiles) {
        this.nuixProfiles = nuixProfiles;
    }

    public Map<String, String> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setAdditionalFiles(Map<String, String> additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    public String getEngineLogFolder() {
        if (this.engineLogFolder != null) {
            return this.engineLogFolder.trim();
        }
        return this.engineLogFolder;
    }

    public void setEngineLogFolder(String engineLogFolder) {
        this.engineLogFolder = engineLogFolder;
    }

    public String getNuixEngineFolder() {
        if (this.nuixEngineFolder != null) {
            return this.nuixEngineFolder.trim();
        }
        return this.nuixEngineFolder;
    }

    public void setNuixEngineFolder(String nuixEngineFolder) {
        this.nuixEngineFolder = nuixEngineFolder;
    }

    public String getJavaFolder() {
        return this.javaFolder;
    }

    public void setJavaFolder(String javaFolder) {
        this.javaFolder = javaFolder;
    }

    public List<String> getNotificationRuleIds() {
        return this.notificationRuleIds;
    }

    public void setNotificationRuleIds(List<String> notificationRuleIds) {
        this.notificationRuleIds = notificationRuleIds;
    }

    public String toString() {
        try {
            return "executionProfile " + this.getName() + " (" + FormattingUtils.getShortId(this.getId(), 8) + ")";
        }
        catch (Exception e) {
            return "executionProfile " + this.getName() + " (N/A)";
        }
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public JobTimeoutSettings getJobTimeoutSettings() {
        return this.jobTimeoutSettings;
    }

    public void setJobTimeoutSettings(JobTimeoutSettings jobTimeoutSettings) {
        this.jobTimeoutSettings = jobTimeoutSettings;
    }

    public String getDuplicateReferenceId() {
        return this.duplicateReferenceId;
    }

    public void setDuplicateReferenceId(String duplicateReferenceId) {
        this.duplicateReferenceId = duplicateReferenceId;
    }

    @JsonIgnore
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @JsonIgnore
    public String getReferenceVersion() {
        return this.referenceVersion;
    }

    public void setReferenceVersion(String referenceVersion) {
        this.referenceVersion = referenceVersion;
    }

    public String getSchedulerUrl() {
        return this.schedulerUrl;
    }

    public void setSchedulerUrl(String schedulerUrl) {
        this.schedulerUrl = schedulerUrl;
    }

    public String getSchedulerCertFingeprint() {
        return this.schedulerCertFingeprint;
    }

    public void setSchedulerCertFingeprint(String schedulerCertFingeprint) {
        this.schedulerCertFingeprint = schedulerCertFingeprint;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Execution Profile " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getEngineLogFolder() == null) {
            if (SystemUtils.getOsWindows()) {
                this.setEngineLogFolder("C:\\Temp\\Logs");
            } else {
                this.setEngineLogFolder("/var/log/nuix/automate");
            }
        }
        if (this.getWorkerTempFolder() == null) {
            if (SystemUtils.getOsWindows()) {
                this.setWorkerTempFolder(WorkerTempFolder.WINDOWS.getPath());
            } else {
                this.setWorkerTempFolder(WorkerTempFolder.OTHER.getPath());
            }
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public JobProgressSettings getJobProgressSettings() {
        return this.jobProgressSettings;
    }

    public void setJobProgressSettings(JobProgressSettings jobProgressSettings) {
        this.jobProgressSettings = jobProgressSettings;
    }

    public String getWorkerTempFolder() {
        return this.workerTempFolder;
    }

    public void setWorkerTempFolder(String workerTempFolder) {
        this.workerTempFolder = workerTempFolder;
    }
}

