/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.formbuilder;

import com.nuix.automate.utils.models.internal.formbuilder.BooleanOperator;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.HelperValues;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.OnValues;
import com.nuix.automate.utils.models.internal.formbuilder.PositionedLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ComponentConfiguration {
    private Object name;
    private String label;
    private String group;
    private Boolean disabled;
    private FieldComponentType componentType;
    private List<ComponentConfiguration> componentConfigurations;
    private Integer order;
    private Integer naturalOrder;
    private PositionedLabel positionedLabel;
    private Map<String, OnValues> enableOn;
    private BooleanOperator enableOnOperator;
    private Map<String, OnValues> visibleOn;
    private BooleanOperator visibleOnOperator;
    private List<HelperValues> helperValues;

    protected static Map<String, OnValues> buildOnValuesMap(OnField[] onFields) {
        if (onFields.length == 0) {
            return null;
        }
        HashMap<String, OnValues> onValues = new HashMap<String, OnValues>();
        for (OnField onField : onFields) {
            onValues.put(onField.name(), new OnValues(onField));
        }
        return onValues;
    }

    protected static List<HelperValues> buildHelperValues(FormFieldHelper[] formFieldHelpers) {
        if (formFieldHelpers.length == 0) {
            return null;
        }
        ArrayList<HelperValues> helperValuesList = new ArrayList<HelperValues>();
        for (FormFieldHelper formFieldHelper : formFieldHelpers) {
            helperValuesList.add(new HelperValues(formFieldHelper));
        }
        return helperValuesList;
    }

    public Integer getSortOrder() {
        if (this.order != null) {
            return this.order;
        }
        return this.naturalOrder;
    }

    public Object getName() {
        return this.name;
    }

    public void setName(Object name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public FieldComponentType getComponentType() {
        return this.componentType;
    }

    public void setComponentType(FieldComponentType componentType) {
        this.componentType = componentType;
    }

    public List<ComponentConfiguration> getComponentConfigurations() {
        return this.componentConfigurations;
    }

    public void setComponentConfigurations(List<ComponentConfiguration> componentConfigurations) {
        this.componentConfigurations = componentConfigurations;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Integer getNaturalOrder() {
        return this.naturalOrder;
    }

    public void setNaturalOrder(Integer naturalOrder) {
        this.naturalOrder = naturalOrder;
    }

    public PositionedLabel getPositionedLabel() {
        return this.positionedLabel;
    }

    public void setPositionedLabel(PositionedLabel positionedLabel) {
        this.positionedLabel = positionedLabel;
    }

    public Map<String, OnValues> getEnableOn() {
        return this.enableOn;
    }

    public void setEnableOn(Map<String, OnValues> enableOn) {
        this.enableOn = enableOn;
    }

    public BooleanOperator getEnableOnOperator() {
        return this.enableOnOperator;
    }

    public void setEnableOnOperator(BooleanOperator enableOnOperator) {
        this.enableOnOperator = enableOnOperator;
    }

    public Map<String, OnValues> getVisibleOn() {
        return this.visibleOn;
    }

    public void setVisibleOn(Map<String, OnValues> visibleOn) {
        this.visibleOn = visibleOn;
    }

    public BooleanOperator getVisibleOnOperator() {
        return this.visibleOnOperator;
    }

    public void setVisibleOnOperator(BooleanOperator visibleOnOperator) {
        this.visibleOnOperator = visibleOnOperator;
    }

    public List<HelperValues> getHelperValues() {
        return this.helperValues;
    }

    public void setHelperValues(List<HelperValues> helperValues) {
        this.helperValues = helperValues;
    }
}

