/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.formbuilder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.ReflectionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.ComponentConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldColumnConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionedLabel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class FieldConfiguration
extends ComponentConfiguration {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FieldConfiguration.class);
    @JsonIgnore
    private transient Class<?> fieldClass;
    private FormConfiguration formConfiguration;
    private String type;
    private String enumName;
    private String placeholder;
    private Object defaultValue;
    private boolean required;
    private boolean keepLabel;
    private String scriptLanguage;
    private String scriptLanguageField;
    private String parameterType;
    private Integer divisor;
    private Integer rowSize;
    private Double min;
    private Double max;
    private String regex;
    private List<String> allowedValues;
    private DynamicValuesType dynamicValuesType;

    public FieldConfiguration() {
    }

    public FieldConfiguration(Object name, Object defaultValue) {
        this.setName(name);
        this.defaultValue = defaultValue;
    }

    public FieldConfiguration(FormField formField, Field field) {
        this.setType(field.getType().getSimpleName().toLowerCase());
        this.setName(field.getName());
        this.setComponentType(formField.componentType());
        if (formField.fieldClass() != Object.class) {
            this.fieldClass = formField.fieldClass();
            this.setComponentType(FieldComponentType.OBJECT);
        }
        if (this.getComponentType() == FieldComponentType.NULL) {
            this.setComponentType(FieldComponentType.deduceFieldComponentType(field));
        }
        if (formField.order() >= 0) {
            this.setOrder(formField.order());
        }
        switch (this.getComponentType()) {
            case OBJECT: 
            case OBJECT_LIST: 
            case OBJECT_TABLE: 
            case INPUT_LIST: {
                if (formField.columnFields().length <= 0) break;
                ArrayList<ComponentConfiguration> columnFieldConfigurations = new ArrayList<ComponentConfiguration>();
                for (int i = 0; i < formField.columnFields().length; ++i) {
                    columnFieldConfigurations.add(new FieldColumnConfiguration((Object)i, formField.columnFields()[i]));
                }
                this.setComponentConfigurations(columnFieldConfigurations);
            }
        }
        if (formField.label().isEmpty()) {
            this.setLabel(field.getName());
        } else {
            this.setLabel(formField.label());
        }
        this.setKeepLabel(formField.keepLabel());
        this.setPositionedLabel(new PositionedLabel(formField.positionLabel()));
        if (!formField.placeholder().isEmpty()) {
            this.setPlaceholder(formField.placeholder());
        }
        if (this.getComponentType() == FieldComponentType.NUMBER && formField.divisor() > 0) {
            this.divisor = formField.divisor();
        }
        if (this.getComponentType() == FieldComponentType.TEXTAREA || this.getComponentType() == FieldComponentType.SCRIPT_PANE) {
            if (formField.rowSize() > 0) {
                this.rowSize = formField.rowSize();
            } else if (this.getComponentType() == FieldComponentType.SCRIPT_PANE) {
                this.rowSize = 24;
            }
        }
        if (this.getComponentType() == FieldComponentType.SCRIPT_PANE) {
            if (!formField.scriptLanguage().isEmpty()) {
                this.scriptLanguage = formField.scriptLanguage();
            }
            if (!formField.scriptLanguageField().isEmpty()) {
                this.scriptLanguageField = formField.scriptLanguageField();
            }
        }
        if (!(this.getComponentType() != FieldComponentType.PARAMETER_INPUT && this.getComponentType() != FieldComponentType.PARAMETER_DROPDOWN || formField.parameterType().isEmpty())) {
            this.parameterType = formField.parameterType();
        }
        if (this.getComponentType() != FieldComponentType.CHECKBOX && this.getComponentType() != FieldComponentType.RADIO_BUTTON) {
            this.required = formField.required();
        }
        if (this.getComponentType() == FieldComponentType.NUMBER) {
            this.min = formField.min();
            if (formField.max() != 2.147483647E9) {
                this.max = formField.max();
            }
        }
        if (!formField.regex().isEmpty()) {
            this.regex = formField.regex();
        }
        this.setVisibleOn(FieldConfiguration.buildOnValuesMap(formField.visibleOn()));
        if (this.getVisibleOn() != null) {
            this.setVisibleOnOperator(formField.visibleOnOperator());
        }
        this.setEnableOn(FieldConfiguration.buildOnValuesMap(formField.enableOn()));
        if (this.getEnableOn() != null) {
            this.setEnableOnOperator(formField.enableOnOperator());
        }
        this.setHelperValues(FieldConfiguration.buildHelperValues(formField.helpers()));
        Class enumClazz = field.getType();
        if (formField.enumClass().isEnum()) {
            enumClazz = formField.enumClass();
        } else if (Collection.class.isAssignableFrom(enumClazz)) {
            enumClazz = (Class)ReflectionUtils.getGenericParameterizedTypeArguments(field)[0];
        }
        this.populateAllowedValues(formField.allowedValues(), enumClazz);
        if (formField.excludeValues().length > 0) {
            this.allowedValues.removeAll(Arrays.asList(formField.excludeValues()));
        }
        this.setDefaultValue(this.getEffectiveDefaultValue());
    }

    protected void populateAllowedValues(String[] allowedValues, Class<?> enumClazz) {
        if (allowedValues.length > 0) {
            this.allowedValues = new ArrayList<String>(Arrays.asList(allowedValues));
        }
        if (enumClazz.isEnum()) {
            this.enumName = enumClazz.getSimpleName();
            ArrayList<String> enumValues = new ArrayList<String>();
            for (Object enumConstant : enumClazz.getEnumConstants()) {
                try {
                    String serializedValue = SerializationUtils.enumToJsonString((Enum)enumConstant);
                    enumValues.add(serializedValue);
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing enum field: " + ((Enum)enumConstant).name(), e);
                }
            }
            if (this.allowedValues != null) {
                this.allowedValues.retainAll(enumValues);
            } else {
                this.allowedValues = enumValues;
            }
        }
    }

    protected Object getEffectiveDefaultValue() {
        return this.getEffectiveDefaultValue(null);
    }

    protected Object getEffectiveDefaultValue(Object defaultValue) {
        if (defaultValue == null) {
            defaultValue = this.defaultValue;
        }
        if (defaultValue == null) {
            switch (this.getComponentType()) {
                case RADIO_BUTTON: {
                    if (!this.getType().equalsIgnoreCase(Boolean.class.getSimpleName())) {
                        return this.allowedValues.get(0);
                    }
                }
                case CHECKBOX: {
                    return false;
                }
                case NUMBER: 
                case DATE: 
                case TIME: 
                case DATE_TIME: {
                    return 0L;
                }
                case OBJECT: {
                    return new HashMap();
                }
                case OBJECT_LIST: 
                case OBJECT_TABLE: 
                case INPUT_LIST: 
                case DROPDOWN_SELECTED_LIST: 
                case PARAMETER_TABLE: {
                    return new Object[0];
                }
            }
            return "";
        }
        return defaultValue;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(Class<?> fieldClass) {
        this.fieldClass = fieldClass;
    }

    public FormConfiguration getFormConfiguration() {
        return this.formConfiguration;
    }

    public void setFormConfiguration(FormConfiguration formConfiguration) {
        this.formConfiguration = formConfiguration;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public void setEnumName(String enumName) {
        this.enumName = enumName;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean getKeepLabel() {
        return this.keepLabel;
    }

    public void setKeepLabel(boolean keepLabel) {
        this.keepLabel = keepLabel;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public String getScriptLanguageField() {
        return this.scriptLanguageField;
    }

    public void setScriptLanguageField(String scriptLanguageField) {
        this.scriptLanguageField = scriptLanguageField;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public Integer getDivisor() {
        return this.divisor;
    }

    public void setDivisor(Integer divisor) {
        this.divisor = divisor;
    }

    public Integer getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(Integer rowSize) {
        this.rowSize = rowSize;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public DynamicValuesType getDynamicValuesType() {
        return this.dynamicValuesType;
    }

    public void setDynamicValuesType(DynamicValuesType dynamicValuesType) {
        this.dynamicValuesType = dynamicValuesType;
    }
}

