/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.formbuilder;

import com.nuix.automate.utils.models.internal.formbuilder.ComponentConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FieldGroupConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.PositionedLabel;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValueConfiguration;
import java.util.LinkedHashMap;

public class FieldRadioButtonGroupConfiguration
extends FieldGroupConfiguration {
    private FieldConfiguration radioButtonConfiguration;
    private LinkedHashMap<String, RadioButtonValueConfiguration> valueConfigurations;

    public FieldRadioButtonGroupConfiguration() {
    }

    public FieldRadioButtonGroupConfiguration(FormFieldRadioButtonGroup radioButtonGroup) {
        this.valueConfigurations = new LinkedHashMap();
        this.setName(radioButtonGroup.name());
        this.setComponentType(radioButtonGroup.componentType());
        if (this.getComponentType() != FieldComponentType.RADIO_BUTTON_GROUP && this.getComponentType() != FieldComponentType.RADIO_BUTTON_CHECKBOX_GROUP) {
            this.setComponentType(FieldComponentType.RADIO_BUTTON_GROUP);
        }
        this.setStyled(radioButtonGroup.styled());
        if (!radioButtonGroup.label().isEmpty()) {
            this.setLabel(radioButtonGroup.label());
        }
        this.setPositionedLabel(new PositionedLabel(radioButtonGroup.positionLabel()));
        this.setVisibleOn(FieldRadioButtonGroupConfiguration.buildOnValuesMap(radioButtonGroup.visibleOn()));
        if (this.getVisibleOn() != null) {
            this.setVisibleOnOperator(radioButtonGroup.visibleOnOperator());
        }
        this.setEnableOn(FieldRadioButtonGroupConfiguration.buildOnValuesMap(radioButtonGroup.enableOn()));
        if (this.getEnableOn() != null) {
            this.setEnableOnOperator(radioButtonGroup.enableOnOperator());
        }
    }

    @Override
    public Integer getSortOrder() {
        if (this.radioButtonConfiguration != null) {
            return this.radioButtonConfiguration.getSortOrder();
        }
        Integer sortOrder = super.getSortOrder();
        if (this.valueConfigurations != null) {
            for (ComponentConfiguration componentConfiguration : this.valueConfigurations.values()) {
                Integer order = componentConfiguration.getSortOrder();
                if (sortOrder != null && (order == null || order.compareTo(sortOrder) >= 0)) continue;
                sortOrder = order;
            }
        }
        return sortOrder;
    }

    public FieldConfiguration getRadioButtonConfiguration() {
        return this.radioButtonConfiguration;
    }

    public void setRadioButtonConfiguration(FieldConfiguration radioButtonConfiguration) {
        this.radioButtonConfiguration = radioButtonConfiguration;
    }

    public LinkedHashMap<String, RadioButtonValueConfiguration> getValueConfigurations() {
        return this.valueConfigurations;
    }

    public void setValueConfigurations(LinkedHashMap<String, RadioButtonValueConfiguration> valueConfigurations) {
        this.valueConfigurations = valueConfigurations;
    }
}

