/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.job;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.internal.job.JobModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JobDetailsModel
implements Serializable {
    private JobModel settings;
    private List<OperationStatus> operations;
    private List<AuditEvent> auditLog;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobDetailsModel.class);

    public List<OperationStatus> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationStatus> operations) {
        this.operations = operations;
    }

    public void setSettings(JobModel settings) {
        this.settings = settings;
    }

    public JobModel getSettings() {
        if (this.settings == null) {
            return this.settings;
        }
        boolean hasWarnings = false;
        if (this.settings.getWarnings() != null && this.settings.getWarnings().size() > 0) {
            hasWarnings = true;
        }
        boolean hasSoftErrors = false;
        if (this.operations != null) {
            for (OperationStatus operationStatus : this.operations) {
                if (operationStatus.getWarnings() != null && operationStatus.getWarnings().size() > 0) {
                    hasWarnings = true;
                }
                if (operationStatus.hasSoftErrors()) {
                    hasSoftErrors = true;
                }
                if (!hasWarnings || !hasSoftErrors) continue;
                break;
            }
        }
        this.settings.setHasWarnings(hasWarnings);
        this.settings.setHasSoftErrors(hasSoftErrors);
        return this.settings;
    }

    public List<AuditEvent> getAuditLog() {
        if (this.auditLog == null) {
            this.auditLog = new ArrayList<AuditEvent>();
        }
        return this.auditLog;
    }

    public void setAuditLog(List<AuditEvent> auditLog) {
        this.auditLog = auditLog;
    }

    public JobDetailsModel() {
    }

    public JobDetailsModel(JobDetailsModel original) {
        this(original, false, false);
    }

    public JobDetailsModel(JobDetailsModel original, boolean maskProtectedParameters, boolean hideDetailsIfConfidential) {
        if (hideDetailsIfConfidential && original.settings.confidentialitySet()) {
            this.operations = new ArrayList<OperationStatus>();
            this.auditLog = new ArrayList<AuditEvent>();
        } else {
            this.operations = new ArrayList<OperationStatus>();
            List<OperationStatus> originalOperations = original.operations;
            if (originalOperations != null) {
                for (OperationStatus originalOperation : originalOperations) {
                    OperationStatus copyOperation = new OperationStatus(originalOperation);
                    this.operations.add(copyOperation);
                }
            }
            this.auditLog = new ArrayList<AuditEvent>();
            List<AuditEvent> originalEventLog = original.getAuditLog();
            if (originalEventLog != null) {
                this.auditLog.addAll(originalEventLog);
            }
        }
        this.settings = new JobModel(original.settings, maskProtectedParameters, hideDetailsIfConfidential);
    }

    public String toString() {
        return this.settings.toString();
    }
}

