/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.job;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class JobFilePayload {
    private String jobId;
    private String fileName;
    private Long createdDate;
    private Long expirationDate;

    public JobFilePayload() {
    }

    public JobFilePayload(String jobId, String fileName) {
        this(jobId, fileName, 12);
    }

    public JobFilePayload(String jobId, String fileName, int lifetimeHours) {
        this.jobId = jobId;
        this.fileName = fileName;
        this.createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.expirationDate = this.createdDate + (long)(lifetimeHours * 60 * 60) * 1000L;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }
}

