/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.job;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.ExecutionParameter;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Command;
import com.nuix.automate.utils.models.api.job.JobRequiredProfile;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.internal.job.RemoteWorkersSpecModel;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LinkLog;
import com.nuix.automate.utils.workflow.ScheduleEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

public class JobModel
extends UserPermissionModel
implements Serializable {
    private String id;
    private String matterId;
    private String matterName;
    private String matterReference;
    private boolean matterLock;
    private String clientId;
    private String clientName;
    private String clientReference;
    private String engineId;
    private List<String> workerAgentIds;
    private boolean engineHasWarnings;
    private boolean missingRequiredProfiles;
    private boolean inStaging;
    private Long autoSubmitOnDate;
    private String engineName;
    private String serverId;
    private String serverName;
    private String executionProfileId;
    private String executionProfileName;
    private String resourcePoolId;
    private String resourcePoolName;
    private String lastResourcePoolId;
    private Priority priority;
    private String stagedBy;
    private String stagedUserId;
    private String submittedBy;
    private String submitterUserId;
    private String modifiedBy;
    private Long startedDate;
    private Long finishedDate;
    private Long stagedDate;
    private Long submittedDate;
    private Long originalSubmittedDate;
    private Long resubmittedDate;
    private Long lastStateChangedDate;
    private String name;
    private String workflowName;
    private String savedState;
    private String libraryWorkflowId;
    private String libraryId;
    private String notes;
    private ExecutionState executionState;
    private String error;
    private List<String> softErrors;
    private List<String> warnings;
    private List<String> infos;
    private List<LinkLog> links;
    private List<Parameter> sessionParameters;
    private List<Parameter> defaultParameters;
    private List<ExecutionParameter> executionParameters;
    private String sessionParametersKeyId;
    private boolean parameterLock;
    private double percentageComplete;
    private Boolean confidential;
    private Boolean locked;
    private Boolean hasWarnings;
    private Boolean hasSoftErrors;
    private boolean bootstrap;
    private String scheduleId;
    private RemoteWorkersSpecModel remoteWorkersSpec;
    private boolean excludeUtilization;
    private Integer runningOperationId;
    private ExecutionMode executionMode;
    private OperationStatus runningOperationStatus;
    private List<JobRequiredProfile> requiredProfiles;
    private String originalJobId;
    private ScheduleEvent scheduleEvent;
    private String jobApiBearerToken;
    private String currentOperationProcessingSpeedText;
    private String originalJobSubmitterUserId;
    private Command jobCommand;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobModel.class);

    public JobModel() {
    }

    public JobModel buildResubmission() {
        JobModel resubmissionJob = new JobModel();
        resubmissionJob.setOriginalJobId(this.id);
        resubmissionJob.setSubmitterUserId(this.submitterUserId);
        resubmissionJob.setStagedUserId(this.stagedUserId);
        resubmissionJob.setName(this.name);
        resubmissionJob.setClientId(this.clientId);
        resubmissionJob.setMatterId(this.matterId);
        resubmissionJob.setLibraryId(this.libraryId);
        resubmissionJob.setLibraryWorkflowId(this.libraryWorkflowId);
        resubmissionJob.setExecutionProfileId(this.executionProfileId);
        resubmissionJob.setResourcePoolId(this.resourcePoolId);
        resubmissionJob.setPriority(this.priority);
        resubmissionJob.setNotes(this.notes);
        resubmissionJob.setOriginalJobSubmitterUserId(this.originalJobSubmitterUserId);
        resubmissionJob.setSessionParameters(new ArrayList<Parameter>());
        if (this.sessionParameters != null) {
            for (Parameter parameter : this.sessionParameters) {
                Parameter duplicatedParameter = new Parameter(parameter);
                resubmissionJob.getSessionParameters().add(duplicatedParameter);
            }
        }
        this.executionParameters = new ArrayList<ExecutionParameter>();
        resubmissionJob.setScheduleEvent(this.scheduleEvent);
        return resubmissionJob;
    }

    public String getSavedState() {
        return this.savedState;
    }

    public void setSavedState(String savedState) {
        this.savedState = savedState;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getMatterName() {
        return this.matterName;
    }

    public void setMatterName(String matterName) {
        this.matterName = matterName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getResourcePoolName() {
        return this.resourcePoolName;
    }

    public void setResourcePoolName(String resourcePoolName) {
        this.resourcePoolName = resourcePoolName;
    }

    public String getLibraryWorkflowId() {
        return this.libraryWorkflowId;
    }

    public void setLibraryWorkflowId(String libraryWorkflowId) {
        this.libraryWorkflowId = libraryWorkflowId;
    }

    public List<JobRequiredProfile> getRequiredProfiles() {
        return this.requiredProfiles;
    }

    public void setRequiredProfiles(List<JobRequiredProfile> requiredProfiles) {
        this.requiredProfiles = requiredProfiles;
    }

    public String getOriginalJobId() {
        return this.originalJobId;
    }

    public void setOriginalJobId(String originalJobId) {
        this.originalJobId = originalJobId;
    }

    public String getOriginalJobSubmitterUserId() {
        return this.originalJobSubmitterUserId;
    }

    public void setOriginalJobSubmitterUserId(String originalJobSubmitterUserId) {
        this.originalJobSubmitterUserId = originalJobSubmitterUserId;
    }

    public JobModel(JobModel o) {
        this(o, false, false);
    }

    public Long getResubmittedDate() {
        if (this.resubmittedDate != null) {
            return this.resubmittedDate;
        }
        if (this.submittedDate != null) {
            return this.submittedDate;
        }
        return this.stagedDate;
    }

    public void setResubmittedDate(Long resubmittedDate) {
        this.resubmittedDate = resubmittedDate;
    }

    public Command getJobCommand() {
        return this.jobCommand;
    }

    public void setJobCommand(Command jobCommand) {
        this.jobCommand = jobCommand;
    }

    public JobModel(JobModel o, boolean maskProtectedParameters, boolean hideDetailsIfConfidential) {
        this.id = o.id;
        this.engineId = o.engineId;
        this.engineName = o.engineName;
        this.serverId = o.serverId;
        this.serverName = o.serverName;
        this.resourcePoolId = o.resourcePoolId;
        this.resourcePoolName = o.resourcePoolName;
        this.lastResourcePoolId = o.lastResourcePoolId;
        this.executionProfileId = o.executionProfileId;
        this.executionProfileName = o.executionProfileName;
        this.priority = o.priority;
        this.submittedBy = o.submittedBy;
        this.stagedBy = o.stagedBy;
        this.modifiedBy = o.modifiedBy;
        this.submittedDate = o.submittedDate;
        this.originalSubmittedDate = o.originalSubmittedDate;
        this.stagedDate = o.stagedDate;
        this.startedDate = o.startedDate;
        this.finishedDate = o.finishedDate;
        this.lastStateChangedDate = o.lastStateChangedDate;
        this.resubmittedDate = o.resubmittedDate;
        this.engineHasWarnings = o.engineHasWarnings;
        this.missingRequiredProfiles = o.missingRequiredProfiles;
        this.inStaging = o.inStaging;
        this.autoSubmitOnDate = o.autoSubmitOnDate;
        this.matterLock = o.matterLock;
        this.parameterLock = o.parameterLock;
        this.scheduleId = o.scheduleId;
        this.remoteWorkersSpec = o.remoteWorkersSpec;
        this.excludeUtilization = o.excludeUtilization;
        this.runningOperationStatus = o.runningOperationStatus;
        this.scheduleEvent = o.scheduleEvent;
        this.currentOperationProcessingSpeedText = o.currentOperationProcessingSpeedText;
        this.originalJobSubmitterUserId = o.originalJobSubmitterUserId;
        if (maskProtectedParameters || hideDetailsIfConfidential) {
            this.submitterUserId = null;
            this.stagedUserId = null;
            this.jobApiBearerToken = null;
        } else {
            this.submitterUserId = o.submitterUserId;
            this.stagedUserId = o.stagedUserId;
            this.jobApiBearerToken = o.jobApiBearerToken;
        }
        if (o.confidential != null && o.confidential.booleanValue() && hideDetailsIfConfidential) {
            this.workflowName = "";
            this.notes = "";
            this.error = "";
            this.locked = true;
            this.name = "Confidential";
            this.savedState = null;
            this.runningOperationId = null;
        } else {
            this.runningOperationId = o.runningOperationId;
            this.workflowName = o.workflowName;
            this.notes = o.notes;
            this.error = o.error;
            this.locked = false;
            this.matterId = o.matterId;
            this.matterName = o.matterName;
            this.matterReference = o.matterReference;
            this.clientId = o.clientId;
            this.clientName = o.clientName;
            this.clientReference = o.clientReference;
            this.name = o.name;
            this.libraryWorkflowId = o.libraryWorkflowId;
            this.libraryId = o.libraryId;
            this.savedState = o.savedState;
        }
        this.executionState = o.executionState;
        this.workerAgentIds = new ArrayList<String>();
        if (o.workerAgentIds != null) {
            this.workerAgentIds.addAll(o.workerAgentIds);
        }
        this.warnings = new ArrayList<String>();
        this.softErrors = new ArrayList<String>();
        this.infos = new ArrayList<String>();
        this.links = new ArrayList<LinkLog>();
        if (o.confidential == null || !o.confidential.booleanValue() || !hideDetailsIfConfidential) {
            Parameter newParameterModel;
            if (o.warnings != null) {
                this.warnings.addAll(o.warnings);
            }
            if (o.softErrors != null) {
                this.softErrors.addAll(o.softErrors);
            }
            if (o.infos != null) {
                this.infos.addAll(o.infos);
            }
            if (o.links != null) {
                this.links.addAll(o.links);
            }
            this.sessionParametersKeyId = o.sessionParametersKeyId;
            this.sessionParameters = new ArrayList<Parameter>();
            if (o.sessionParameters != null) {
                for (Parameter oParameterModel : o.sessionParameters) {
                    newParameterModel = new Parameter(oParameterModel);
                    if (maskProtectedParameters && (newParameterModel.isProtected() || newParameterModel.isMasked()) && (newParameterModel.getValue() == null || newParameterModel.getValue().length() > 0)) {
                        newParameterModel.setValue(null);
                    }
                    this.sessionParameters.add(newParameterModel);
                }
            }
            this.defaultParameters = new ArrayList<Parameter>();
            if (o.defaultParameters != null) {
                for (Parameter oParameterModel : o.defaultParameters) {
                    newParameterModel = new Parameter(oParameterModel);
                    if (maskProtectedParameters && (newParameterModel.isProtected() || newParameterModel.isMasked()) && (newParameterModel.getValue() == null || newParameterModel.getValue().length() > 0)) {
                        newParameterModel.setValue(null);
                    }
                    this.defaultParameters.add(newParameterModel);
                }
            }
        }
        this.requiredProfiles = new ArrayList<JobRequiredProfile>();
        if (o.requiredProfiles != null) {
            this.requiredProfiles.addAll(o.requiredProfiles);
        }
        this.executionParameters = new ArrayList<ExecutionParameter>();
        if (o.executionParameters != null) {
            this.executionParameters.addAll(o.executionParameters);
        }
        this.percentageComplete = o.percentageComplete;
        this.confidential = o.confidential;
        this.hasWarnings = o.hasWarnings;
        this.hasSoftErrors = o.hasSoftErrors;
    }

    @JsonProperty
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @JsonProperty
    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @JsonProperty
    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public List<Parameter> getSessionParameters() {
        if (this.sessionParameters == null) {
            this.sessionParameters = new ArrayList<Parameter>();
        }
        return this.sessionParameters;
    }

    public List<Parameter> getDefaultParameters() {
        if (this.defaultParameters == null) {
            this.defaultParameters = new ArrayList<Parameter>();
        }
        return this.defaultParameters;
    }

    public List<ExecutionParameter> getExecutionParameters() {
        if (this.executionParameters == null) {
            this.executionParameters = new ArrayList<ExecutionParameter>();
        }
        return this.executionParameters;
    }

    public void setExecutionParameters(List<ExecutionParameter> executionParameters) {
        this.executionParameters = executionParameters;
    }

    public boolean hasError() {
        return this.error != null && this.error.trim().length() > 0;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public void setSoftErrors(List<String> softErrors) {
        this.softErrors = softErrors;
    }

    public void setInfos(List<String> infos) {
        this.infos = infos;
    }

    public void setLinks(List<LinkLog> links) {
        this.links = links;
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        return this.warnings;
    }

    public List<String> getSoftErrors() {
        if (this.softErrors == null) {
            this.softErrors = new ArrayList<String>();
        }
        return this.softErrors;
    }

    public List<String> getInfos() {
        if (this.infos == null) {
            this.infos = new ArrayList<String>();
        }
        return this.infos;
    }

    public List<LinkLog> getLinks() {
        if (this.links == null) {
            this.links = new ArrayList<LinkLog>();
        }
        return this.links;
    }

    public double getPercentageComplete() {
        return this.percentageComplete;
    }

    public void setPercentageComplete(double percentageComplete) {
        this.percentageComplete = Math.max(0.0, Math.min(100.0, percentageComplete));
    }

    public void setSessionParameters(List<Parameter> sessionParameters) {
        this.sessionParameters = sessionParameters;
    }

    public void setDefaultParameters(List<Parameter> defaultParameters) {
        this.defaultParameters = defaultParameters;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getStagedBy() {
        return this.stagedBy;
    }

    public void setStagedBy(String stagedBy) {
        this.stagedBy = stagedBy;
    }

    public String getSubmitterUserId() {
        return this.submitterUserId;
    }

    public void setSubmitterUserId(String submitterUserId) {
        this.submitterUserId = submitterUserId;
    }

    public String getStagedUserId() {
        return this.stagedUserId;
    }

    public void setStagedUserId(String stagedUserId) {
        this.stagedUserId = stagedUserId;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Long getLastStateChangedDate() {
        return this.lastStateChangedDate;
    }

    public Long getOriginalSubmittedDate() {
        return this.originalSubmittedDate;
    }

    public void setOriginalSubmittedDate(Long originalSubmittedDate) {
        this.originalSubmittedDate = originalSubmittedDate;
    }

    public Long getStagedDate() {
        return this.stagedDate;
    }

    public void setStagedDate(Long stagedDate) {
        this.stagedDate = stagedDate;
    }

    public void setLastStateChangedDate(Long lastStateChangedDate) {
        this.lastStateChangedDate = lastStateChangedDate;
    }

    public Long getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Long submittedDate) {
        this.submittedDate = submittedDate;
    }

    public String toString() {
        try {
            return "Job " + this.getName() + " (" + FormattingUtils.getShortId(this.id, 8) + ")";
        }
        catch (Exception e) {
            return "Job " + this.getName() + " (N/A)";
        }
    }

    public Boolean getConfidential() {
        return this.confidential;
    }

    public boolean confidentialitySet() {
        return BooleanUtils.isTrue((Boolean)this.confidential);
    }

    public void setConfidential(Boolean confidential) {
        this.confidential = confidential;
    }

    public Boolean getHasWarnings() {
        return this.hasWarnings;
    }

    public void setHasWarnings(Boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    public Boolean getHasSoftErrors() {
        return this.hasSoftErrors;
    }

    public void setHasSoftErrors(Boolean hasSoftErrors) {
        this.hasSoftErrors = hasSoftErrors;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public String getResourcePoolId() {
        return this.resourcePoolId;
    }

    public void setResourcePoolId(String resourcePoolId) {
        this.resourcePoolId = resourcePoolId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public String getMatterReference() {
        return this.matterReference;
    }

    public void setMatterReference(String matterReference) {
        this.matterReference = matterReference;
    }

    public String getClientReference() {
        return this.clientReference;
    }

    public void setClientReference(String clientReference) {
        this.clientReference = clientReference;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    public void setExecutionProfileName(String executionProfileName) {
        this.executionProfileName = executionProfileName;
    }

    public boolean getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(boolean bootstrap) {
        this.bootstrap = bootstrap;
    }

    public boolean getEngineHasWarnings() {
        return this.engineHasWarnings;
    }

    public void setEngineHasWarnings(boolean engineHasWarnings) {
        this.engineHasWarnings = engineHasWarnings;
    }

    public boolean getMissingRequiredProfiles() {
        return this.missingRequiredProfiles;
    }

    public void setMissingRequiredProfiles(boolean missingRequiredProfiles) {
        this.missingRequiredProfiles = missingRequiredProfiles;
    }

    public boolean getInStaging() {
        return this.inStaging;
    }

    public void setInStaging(boolean inStaging) {
        this.inStaging = inStaging;
    }

    public Long getAutoSubmitOnDate() {
        return this.autoSubmitOnDate;
    }

    public void setAutoSubmitOnDate(Long autoSubmitOnDate) {
        this.autoSubmitOnDate = autoSubmitOnDate;
    }

    public boolean getMatterLock() {
        return this.matterLock;
    }

    public void setMatterLock(boolean matterLock) {
        this.matterLock = matterLock;
    }

    public boolean getParameterLock() {
        return this.parameterLock;
    }

    public void setParameterLock(boolean parameterLock) {
        this.parameterLock = parameterLock;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public boolean clearSensitiveValues() {
        boolean updated = false;
        if (this.savedState != null) {
            this.savedState = null;
            updated = true;
        }
        if (this.sessionParametersKeyId != null) {
            this.sessionParametersKeyId = null;
            updated = true;
        }
        return updated;
    }

    public String getSessionParametersKeyId() {
        return this.sessionParametersKeyId;
    }

    public void setSessionParametersKeyId(String sessionParametersKeyId) {
        this.sessionParametersKeyId = sessionParametersKeyId;
    }

    public RemoteWorkersSpecModel getRemoteWorkersSpec() {
        return this.remoteWorkersSpec;
    }

    public void setRemoteWorkersSpec(RemoteWorkersSpecModel remoteWorkersSpec) {
        this.remoteWorkersSpec = remoteWorkersSpec;
    }

    public List<String> getWorkerAgentIds() {
        return this.workerAgentIds;
    }

    public void setWorkerAgentIds(List<String> workerAgentIds) {
        this.workerAgentIds = workerAgentIds;
    }

    public Long getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Long startedDate) {
        this.startedDate = startedDate;
    }

    public Long getFinishedDate() {
        return this.finishedDate;
    }

    public void setFinishedDate(Long finishedDate) {
        this.finishedDate = finishedDate;
    }

    public boolean getExcludeUtilization() {
        return this.excludeUtilization;
    }

    public void setExcludeUtilization(boolean excludeUtilization) {
        this.excludeUtilization = excludeUtilization;
    }

    public Integer getRunningOperationId() {
        return this.runningOperationId;
    }

    public void setRunningOperationId(Integer runningOperationId) {
        this.runningOperationId = runningOperationId;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Job " + this.getId());
        }
        if (this.getNotes() == null) {
            this.setNotes("");
        }
        if (this.getConfidential() == null) {
            this.setConfidential(false);
        }
        if (this.getSessionParameters() == null) {
            this.setSessionParameters(new ArrayList<Parameter>());
        }
        for (Parameter parameter : this.getSessionParameters()) {
            if (parameter.getDescription() == null) {
                parameter.setDescription("");
            }
            if (parameter.getFriendlyName() != null) continue;
            parameter.setFriendlyName("");
        }
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public OperationStatus getRunningOperationStatus() {
        return this.runningOperationStatus;
    }

    public void setRunningOperationStatus(OperationStatus runningOperationStatus) {
        this.runningOperationStatus = runningOperationStatus;
    }

    public ScheduleEvent getScheduleEvent() {
        return this.scheduleEvent;
    }

    public void setScheduleEvent(ScheduleEvent scheduleEvent) {
        this.scheduleEvent = scheduleEvent;
    }

    public String getLastResourcePoolId() {
        return this.lastResourcePoolId;
    }

    public void setLastResourcePoolId(String lastResourcePoolId) {
        this.lastResourcePoolId = lastResourcePoolId;
    }

    public String getJobApiBearerToken() {
        return this.jobApiBearerToken;
    }

    public void setJobApiBearerToken(String jobApiBearerToken) {
        this.jobApiBearerToken = jobApiBearerToken;
    }

    public String getCurrentOperationProcessingSpeedText() {
        return this.currentOperationProcessingSpeedText;
    }

    public void setCurrentOperationProcessingSpeedText(String currentOperationProcessingSpeedText) {
        this.currentOperationProcessingSpeedText = currentOperationProcessingSpeedText;
    }

    public JobModel cloneLimited() {
        JobModel limited = new JobModel();
        limited.id = this.id;
        limited.name = this.name;
        limited.clientId = this.clientId;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.matterId = this.matterId;
        limited.clientId = this.clientId;
        limited.engineHasWarnings = this.engineHasWarnings;
        limited.inStaging = this.inStaging;
        limited.priority = this.priority;
        limited.startedDate = this.startedDate;
        limited.finishedDate = this.finishedDate;
        limited.stagedDate = this.stagedDate;
        limited.submittedDate = this.submittedDate;
        limited.originalSubmittedDate = this.originalSubmittedDate;
        limited.resubmittedDate = this.resubmittedDate;
        limited.lastStateChangedDate = this.lastStateChangedDate;
        limited.name = this.name;
        limited.libraryWorkflowId = this.libraryWorkflowId;
        limited.libraryId = this.libraryId;
        limited.executionState = this.executionState;
        limited.originalJobSubmitterUserId = this.originalJobSubmitterUserId;
        if (this.error != null && this.error.length() > 0) {
            limited.error = FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + this.error);
        }
        limited.softErrors = new ArrayList<String>();
        if (this.softErrors != null) {
            for (String string : this.softErrors) {
                limited.softErrors.add(FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + string));
            }
        }
        limited.warnings = new ArrayList<String>();
        if (this.warnings != null) {
            for (String string : this.warnings) {
                limited.warnings.add(FormattingUtils.constantToCamelCaseFirstUpper("WARNING") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + string));
            }
        }
        limited.infos = new ArrayList<String>();
        if (this.infos != null) {
            for (String string : this.infos) {
                limited.infos.add(string);
            }
        }
        limited.links = new ArrayList<LinkLog>();
        if (this.links != null) {
            for (LinkLog linkLog : this.links) {
                limited.links.add(linkLog);
            }
        }
        limited.percentageComplete = this.percentageComplete;
        limited.hasWarnings = this.hasWarnings;
        limited.hasSoftErrors = this.hasSoftErrors;
        limited.runningOperationId = this.runningOperationId;
        if (this.runningOperationStatus != null) {
            limited.runningOperationStatus = this.runningOperationStatus.cloneLimited();
        }
        return limited;
    }
}

