/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.job;

import com.nuix.automate.utils.general.FormattingUtils;

public class JobProgress {
    private double jobProgressPercentage;
    private double operationProgressPercentage;
    private int operationId;
    private long itemsProcessed;

    public JobProgress(int operationId, double operationProgressPercentage, double jobProgressPercentage, long itemsProcessed) {
        this.jobProgressPercentage = jobProgressPercentage;
        this.operationId = operationId;
        this.operationProgressPercentage = operationProgressPercentage;
        this.itemsProcessed = itemsProcessed;
    }

    public double getJobProgressPercentage() {
        return this.jobProgressPercentage;
    }

    public void setJobProgressPercentage(double jobProgressPercentage) {
        this.jobProgressPercentage = jobProgressPercentage;
    }

    public double getOperationProgressPercentage() {
        return this.operationProgressPercentage;
    }

    public void setOperationProgressPercentage(double operationProgressPercentage) {
        this.operationProgressPercentage = operationProgressPercentage;
    }

    public int getOperationId() {
        return this.operationId;
    }

    public void setOperationId(int operationId) {
        this.operationId = operationId;
    }

    public long getItemsProcessed() {
        return this.itemsProcessed;
    }

    public void setItemsProcessed(long itemsProcessed) {
        this.itemsProcessed = itemsProcessed;
    }

    public boolean jobProgressGreaterThan(JobProgress originalProgress, double expectedPercentageProgress) {
        return !(this.jobProgressPercentage - originalProgress.getJobProgressPercentage() < expectedPercentageProgress);
    }

    public boolean operationProgressGreaterThan(JobProgress originalProgress, double expectedPercentageProgress) {
        if (this.operationId != originalProgress.operationId) {
            return true;
        }
        return !(this.operationProgressPercentage - originalProgress.getOperationProgressPercentage() < expectedPercentageProgress);
    }

    public String toString() {
        return FormattingUtils.getLocalizedPercentage(this.jobProgressPercentage / 100.0) + " (#" + (this.operationId + 1) + " / " + FormattingUtils.getLocalizedPercentage(this.operationProgressPercentage / 100.0) + " / " + this.itemsProcessed + " items)";
    }
}

