/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.nuix.automate.utils.models.internal.graphapi.Group;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.graphapi.Site;
import com.nuix.automate.utils.models.internal.purview.DataSourceHoldStatus;
import com.nuix.automate.utils.models.internal.purview.DataSourceType;
import io.swagger.v3.oas.annotations.media.Schema;

public class DataSource
extends MicrosoftGraphObject {
    @Schema(description="Source Type")
    private DataSourceType sourceType;
    @Schema(description="Hold Status")
    private DataSourceHoldStatus holdStatus;
    @Schema(description="User Source Email", example="jsmith@example.com")
    private String email;
    @Schema(description="User Source Site Web URL", example="https://example-my.sharepoint.com/personal/jsmith_example_com/")
    private String siteWebUrl;
    @Schema(description="Site")
    private Site site;
    @Schema(description="Group")
    private Group group;
    @Schema(description="Included Sources", example="mailbox, site")
    private String includedSources;

    @JsonIgnore
    public String getDataSourceValue() {
        switch (this.getSourceType()) {
            case USER: {
                return this.email;
            }
            case UNIFIED_GROUP: {
                if ((this.email == null || this.email.isEmpty()) && this.group != null) {
                    return this.group.getMail();
                }
                return this.email;
            }
            case SITE: {
                if ((this.siteWebUrl == null || this.siteWebUrl.isEmpty()) && this.site != null) {
                    return this.site.getWebUrl();
                }
                return this.siteWebUrl;
            }
        }
        return null;
    }

    public DataSourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(DataSourceType sourceType) {
        this.sourceType = sourceType;
    }

    @JsonGetter(value="@odata.type")
    public String getODataSourceType() {
        if (this.sourceType != null) {
            return this.sourceType.getOdataType();
        }
        return null;
    }

    @JsonSetter(value="@odata.type")
    public void setODataSourceType(String odataType) {
        if (odataType.startsWith("#")) {
            odataType = odataType.replaceFirst("#", "");
        }
        this.sourceType = DataSourceType.forOdataType(odataType);
    }

    public DataSourceHoldStatus getHoldStatus() {
        return this.holdStatus;
    }

    public void setHoldStatus(DataSourceHoldStatus holdStatus) {
        this.holdStatus = holdStatus;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSiteWebUrl() {
        return this.siteWebUrl;
    }

    public void setSiteWebUrl(String siteWebUrl) {
        this.siteWebUrl = siteWebUrl;
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public String getIncludedSources() {
        return this.includedSources;
    }

    public void setIncludedSources(String includedSources) {
        this.includedSources = includedSources;
    }

    public String toString() {
        return "DataSource{sourceType=" + (Object)((Object)this.sourceType) + ", holdStatus=" + (Object)((Object)this.holdStatus) + ", email='" + this.email + '\'' + ", siteWebUrl='" + this.siteWebUrl + '\'' + ", site=" + this.site + ", group=" + this.group + ", includedSources='" + this.includedSources + '\'' + ", id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

