/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import io.swagger.v3.oas.annotations.media.Schema;

public class EDiscoveryCaseOcrSettings {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    @Schema(description="Is OCR Enabled for the Case", example="true")
    @FormField
    private Boolean isEnabled = false;
    @Schema(description="Max Image Size in KB", example="24576")
    @FormField(enableOn={@OnField(name="isEnabled")}, positionLabel=@PositionLabel(right="KB"))
    private Integer maxImageSize = 24576;
    @Schema(description="Timeout for OCR Engine in Duration", example="PT1M")
    @FormField(enableOn={@OnField(name="isEnabled")})
    private String timeout = "PT1M";

    @JsonIgnore
    public String isInvalid() {
        if (this.isEnabled == Boolean.TRUE && (this.maxImageSize == null || this.maxImageSize <= 0)) {
            return iu.getString("CaseOcrSettings.InvalidMaxImageSize");
        }
        return null;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public Integer getMaxImageSize() {
        return this.maxImageSize;
    }

    public void setMaxImageSize(Integer maxImageSize) {
        this.maxImageSize = maxImageSize;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }
}

