/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.purview;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import io.swagger.v3.oas.annotations.media.Schema;

public class EDiscoveryCaseTopicModelingSettings {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    @Schema(description="Is Themes Model Enabled for the Case", example="false")
    @FormField
    private Boolean isEnabled = false;
    @Schema(description="Dynamically Optimize Number of Generated Topics", example="true")
    @FormField(enableOn={@OnField(name="isEnabled")})
    private Boolean dynamicallyAdjustTopicCount = true;
    @Schema(description="Exclude Numbers While Parsing Document Texts", example="false")
    @FormField(enableOn={@OnField(name="isEnabled")})
    private Boolean ignoreNumbers = false;
    @Schema(description="Topic Count Model Will Generate", example="100")
    @FormField(enableOn={@OnField(name="isEnabled")})
    private Integer topicCount = 100;

    @JsonIgnore
    public String isInvalid() {
        if (this.isEnabled == Boolean.TRUE && (this.topicCount == null || this.topicCount < 4 || this.topicCount > 10000)) {
            return iu.getString("CaseTopicModelingSettings.InvalidTopicCount");
        }
        return null;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public Boolean getDynamicallyAdjustTopicCount() {
        return this.dynamicallyAdjustTopicCount;
    }

    public void setDynamicallyAdjustTopicCount(Boolean dynamicallyAdjustTopicCount) {
        this.dynamicallyAdjustTopicCount = dynamicallyAdjustTopicCount;
    }

    public Boolean getIgnoreNumbers() {
        return this.ignoreNumbers;
    }

    public void setIgnoreNumbers(Boolean ignoreNumbers) {
        this.ignoreNumbers = ignoreNumbers;
    }

    public Integer getTopicCount() {
        return this.topicCount;
    }

    public void setTopicCount(Integer topicCount) {
        this.topicCount = topicCount;
    }
}

