/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.resourcepool;

import com.nuix.automate.utils.models.api.resourcepool.AzureVmType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class AzureResourcePoolSettings
implements Serializable {
    @Schema(description="Azure Environment", example="Microsoft Commercial")
    private String environment;
    @Schema(description="Azure Tenant", example="11111111-1111-1111-1111-111111111111")
    private String tenant;
    @Schema(description="App Key", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String key;
    @Schema(description="App ID", example="11111111-1111-1111-1111-111111111111")
    private String appId;
    @Schema(description="Subscription ID", example="11111111-1111-1111-1111-111111111111")
    private String subscriptionId;
    @Schema(description="VM Names", example="[\"Server1\",\"Server2\"]")
    private Set<String> vmNames;
    @Schema(description="Azure Custom VM ID", example="11111111-1111-1111-1111-111111111111")
    private String customVmImageId;
    @Schema(description="Azure Custom VM Username", example="Admin5")
    private String customVmUsername;
    @Schema(description="Azure Custom VM Password", example="SecretPassword1!")
    private String customVmPassword;
    @Schema(description="VM Disk Size (GB)", example="100")
    private Integer diskSize;
    @Schema(description="Max Concurrent Instances", example="4")
    private Integer maxConcurrentInstances;
    @Schema(description="Azure Network Name", example="Network 1")
    private String networkName;
    @Schema(description="Azure Network Name", example="default")
    private String networkSubnetName;
    @Schema(description="Azure Network Security Group", example="sample-nsg")
    private String networkSecurityGroup;
    @Schema(description="Azure Location", example="westus")
    private String region;
    @Schema(description="Azure Resource Group ID", example="11111111-1111-1111-1111-111111111111")
    private String resourceGroupId;
    @Schema(description="Azure VM Size", example="Basic_A0")
    private String vmSize;
    @Schema(description="Azure VM Type")
    private AzureVmType vmType;
    @Schema(description="Azure Tag Name", example="instance-type")
    private String tagName;
    @Schema(description="Azure Tag Value", example="automate")
    private String tagValue;

    public String getAppId() {
        return this.appId;
    }

    public AzureResourcePoolSettings() {
    }

    public AzureResourcePoolSettings(AzureResourcePoolSettings copy) {
        this.environment = copy.environment;
        this.tenant = copy.tenant;
        this.key = copy.key;
        this.appId = copy.appId;
        this.subscriptionId = copy.subscriptionId;
        this.vmNames = new HashSet<String>();
        if (copy.vmNames != null) {
            this.vmNames.addAll(copy.vmNames);
        }
        this.customVmImageId = copy.customVmImageId;
        this.diskSize = copy.diskSize;
        this.maxConcurrentInstances = copy.maxConcurrentInstances;
        this.networkName = copy.networkName;
        this.networkSubnetName = copy.networkSubnetName;
        this.networkSecurityGroup = copy.networkSecurityGroup;
        this.region = copy.region;
        this.resourceGroupId = copy.resourceGroupId;
        this.vmSize = copy.vmSize;
        this.vmType = copy.vmType;
        this.tagName = copy.tagName;
        this.tagValue = copy.tagValue;
        this.customVmUsername = copy.customVmUsername;
        this.customVmPassword = copy.customVmPassword;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void removeSecrets() {
        this.key = null;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String secretKey) {
        this.key = secretKey;
    }

    public Set<String> getVmNames() {
        return this.vmNames;
    }

    public void setVmNames(Set<String> vmNames) {
        this.vmNames = vmNames;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getCustomVmImageId() {
        return this.customVmImageId;
    }

    public void setCustomVmImageId(String customVmImageId) {
        this.customVmImageId = customVmImageId;
    }

    public Integer getDiskSize() {
        return this.diskSize;
    }

    public void setDiskSize(Integer diskSize) {
        this.diskSize = diskSize;
    }

    public Integer getMaxConcurrentInstances() {
        return this.maxConcurrentInstances;
    }

    public void setMaxConcurrentInstances(Integer maxConcurrentInstances) {
        this.maxConcurrentInstances = maxConcurrentInstances;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public String getNetworkSubnetName() {
        return this.networkSubnetName;
    }

    public void setNetworkSubnetName(String networkSubnetName) {
        this.networkSubnetName = networkSubnetName;
    }

    public String getNetworkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public void setNetworkSecurityGroup(String networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public void setResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
    }

    public String getVmSize() {
        return this.vmSize;
    }

    public void setVmSize(String vmSize) {
        this.vmSize = vmSize;
    }

    public AzureVmType getVmType() {
        return this.vmType;
    }

    public void setVmType(AzureVmType vmType) {
        this.vmType = vmType;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public String getCustomVmUsername() {
        return this.customVmUsername;
    }

    public void setCustomVmUsername(String customVmUsername) {
        this.customVmUsername = customVmUsername;
    }

    public String getCustomVmPassword() {
        return this.customVmPassword;
    }

    public void setCustomVmPassword(String customVmPassword) {
        this.customVmPassword = customVmPassword;
    }
}

