/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.net.URISyntaxException;
import java.util.Set;

public class LdapUserService
extends UserService {
    private String serviceAccountName;
    private String serviceAccountPassword;
    private String userBaseDn;
    private Integer userSearchScope;
    private String computerBaseDn;
    private Integer computerSearchScope;
    private String ldapHost;
    private Integer ldapPort;
    private String domainDn;
    private Boolean secureLdap;
    private Set<String> whitelistedCertFingerprints;

    @Override
    @JsonIgnore
    public boolean isSameScope(UserService userService) {
        if (!super.isSameScope(userService)) {
            return false;
        }
        if (!(userService instanceof LdapUserService)) {
            return false;
        }
        if (((LdapUserService)userService).getServiceAccountPassword() != null) {
            return false;
        }
        if (this.serviceAccountName != null && !this.serviceAccountName.equals(((LdapUserService)userService).getServiceAccountName())) {
            return false;
        }
        LdapUserService ldapUserService = (LdapUserService)userService;
        if (this.secureLdap != null && !this.secureLdap.equals(ldapUserService.getSecureLdap())) {
            return false;
        }
        if (this.ldapHost != null && !this.ldapHost.equals(ldapUserService.getLdapHost())) {
            return false;
        }
        if (this.ldapPort != null && !this.ldapPort.equals(ldapUserService.getLdapPort())) {
            return false;
        }
        if (this.domainDn != null && !this.domainDn.equals(ldapUserService.getDomainDn())) {
            return false;
        }
        return this.whitelistedCertFingerprints == null || this.whitelistedCertFingerprints.equals(ldapUserService.getWhitelistedCertFingerprints());
    }

    @Override
    public void update(UserService userServiceUpdate) {
        super.update(userServiceUpdate);
        if (((LdapUserService)userServiceUpdate).getServiceAccountName() != null) {
            this.setServiceAccountName(((LdapUserService)userServiceUpdate).getServiceAccountName());
        }
        if (((LdapUserService)userServiceUpdate).getServiceAccountPassword() != null) {
            this.setServiceAccountPassword(((LdapUserService)userServiceUpdate).getServiceAccountPassword());
        }
    }

    @Override
    public LdapUserService clone() {
        return (LdapUserService)super.clone();
    }

    @Override
    public void setEnableCollections(Boolean enableCollections) {
        this.internalSetEnableCollections(enableCollections);
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.ldapHost != null) {
            this.ldapHost = this.ldapHost.trim();
            try {
                this.ldapHost = FormattingUtils.getHostnameFromUrl(this.ldapHost);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public Integer getUserSearchScope() {
        return this.userSearchScope;
    }

    public void setUserSearchScope(Integer userSearchScope) {
        this.userSearchScope = userSearchScope;
    }

    public String getComputerBaseDn() {
        return this.computerBaseDn;
    }

    public void setComputerBaseDn(String computerBaseDn) {
        this.computerBaseDn = computerBaseDn;
    }

    public Integer getComputerSearchScope() {
        return this.computerSearchScope;
    }

    public void setComputerSearchScope(Integer computerSearchScope) {
        this.computerSearchScope = computerSearchScope;
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public String getDomainDn() {
        return this.domainDn;
    }

    public void setDomainDn(String domainDn) {
        this.domainDn = domainDn;
    }

    public Integer getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(Integer ldapPort) {
        this.ldapPort = ldapPort;
    }

    public Boolean getSecureLdap() {
        return this.secureLdap;
    }

    public void setSecureLdap(Boolean secureLdap) {
        this.secureLdap = secureLdap;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public String getServiceAccountPassword() {
        return this.serviceAccountPassword;
    }

    public void setServiceAccountPassword(String serviceAccountPassword) {
        this.serviceAccountPassword = serviceAccountPassword;
    }
}

