/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.models.internal.user.OidcUserServiceType;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.util.Set;

public class OidcUserService
extends UserService {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OidcUserService.class);
    private String clientId;
    private String clientSecret;
    private String wellKnownConfiguration;
    private String scope;
    private String usernameClaim;
    private String groupClaim;
    private OidcUserServiceType oidcUserServiceType;
    private Set<String> whitelistedCertFingerprints;
    private Boolean enableAuthorizationCodeFlow;
    private Boolean enableJwtAccessToken;
    private Boolean defaultAuthenticationProvider;
    private Boolean linkProfilesWithSyncedUsers;

    @Override
    public AuthMethodType getAuthMethodType() {
        if (this.wellKnownConfiguration != null) {
            String wellKnownConfig = this.wellKnownConfiguration.toLowerCase();
            if (wellKnownConfig.contains("accounts.google")) {
                return AuthMethodType.OIDC_GOOGLE;
            }
            if (wellKnownConfig.contains("/relativity/identity/")) {
                return AuthMethodType.OIDC_RELATIVITY;
            }
        }
        return AuthMethodType.OIDC;
    }

    @Override
    @JsonIgnore
    public boolean isSameScope(UserService userService) {
        if (!super.isSameScope(userService)) {
            return false;
        }
        if (!(userService instanceof OidcUserService)) {
            return false;
        }
        OidcUserService oidcUserService = (OidcUserService)userService;
        if (oidcUserService.getClientSecret() != null) {
            return false;
        }
        if (this.clientId != null && !this.clientId.equals(oidcUserService.getClientId())) {
            return false;
        }
        if (this.scope != null && !this.scope.equals(oidcUserService.getScope())) {
            return false;
        }
        return this.wellKnownConfiguration == null || this.wellKnownConfiguration.equals(oidcUserService.getWellKnownConfiguration());
    }

    @Override
    public void update(UserService userServiceUpdate) {
        super.update(userServiceUpdate);
    }

    @Override
    public void setEnableAuthentication(Boolean enableAuthentication) {
        this.internalSetEnableAuthentication(enableAuthentication);
    }

    @Override
    public void normalize() {
        super.normalize();
        this.setDefaults();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getWellKnownConfiguration() {
        return this.wellKnownConfiguration;
    }

    public void setWellKnownConfiguration(String wellKnownConfiguration) {
        this.wellKnownConfiguration = wellKnownConfiguration;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    public void setUsernameClaim(String usernameClaim) {
        this.usernameClaim = usernameClaim;
    }

    public String getGroupClaim() {
        return this.groupClaim;
    }

    public void setGroupClaim(String groupClaim) {
        this.groupClaim = groupClaim;
    }

    public OidcUserServiceType getOidcUserServiceType() {
        return this.oidcUserServiceType;
    }

    public void setOidcUserServiceType(OidcUserServiceType oidcUserServiceType) {
        this.oidcUserServiceType = oidcUserServiceType;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }

    public Boolean getEnableAuthorizationCodeFlow() {
        return this.enableAuthorizationCodeFlow;
    }

    public void setEnableAuthorizationCodeFlow(Boolean enableAuthorizationCodeFlow) {
        this.enableAuthorizationCodeFlow = enableAuthorizationCodeFlow;
    }

    public Boolean getEnableJwtAccessToken() {
        return this.enableJwtAccessToken;
    }

    public void setEnableJwtAccessToken(Boolean enableJwtAccessToken) {
        this.enableJwtAccessToken = enableJwtAccessToken;
    }

    public Boolean getLinkProfilesWithSyncedUsers() {
        return this.linkProfilesWithSyncedUsers;
    }

    public void setLinkProfilesWithSyncedUsers(Boolean linkProfilesWithSyncedUsers) {
        this.linkProfilesWithSyncedUsers = linkProfilesWithSyncedUsers;
    }

    public Boolean getDefaultAuthenticationProvider() {
        return this.defaultAuthenticationProvider;
    }

    public void setDefaultAuthenticationProvider(Boolean defaultAuthenticationProvider) {
        this.defaultAuthenticationProvider = defaultAuthenticationProvider;
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        if (this.enableAuthorizationCodeFlow == null) {
            this.enableAuthorizationCodeFlow = true;
        }
        if (this.enableJwtAccessToken == null) {
            this.enableJwtAccessToken = true;
        }
        if (this.linkProfilesWithSyncedUsers == null) {
            this.linkProfilesWithSyncedUsers = false;
        }
        if (this.defaultAuthenticationProvider == null) {
            this.defaultAuthenticationProvider = false;
        }
    }

    @Override
    public boolean getEnabledForUserTriggerdAuth() {
        return super.getEnabledForUserTriggerdAuth() && Boolean.TRUE.equals(this.enableAuthorizationCodeFlow);
    }
}

