/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.net.URISyntaxException;

public class UmsUserService
extends UserService {
    private String url;
    private String serviceAccountName;
    private String serviceAccountPassword;

    @Override
    @JsonIgnore
    public boolean isSameScope(UserService userService) {
        if (!super.isSameScope(userService)) {
            return false;
        }
        if (!(userService instanceof UmsUserService)) {
            return false;
        }
        if (((UmsUserService)userService).getServiceAccountPassword() != null) {
            return false;
        }
        if (this.serviceAccountName != null && !this.serviceAccountName.equals(((UmsUserService)userService).getServiceAccountName())) {
            return false;
        }
        UmsUserService umsUserService = (UmsUserService)userService;
        return this.url == null || this.url.equals(umsUserService.getUrl());
    }

    @Override
    public void update(UserService userServiceUpdate) {
        super.update(userServiceUpdate);
        if (((UmsUserService)userServiceUpdate).getServiceAccountName() != null) {
            this.setServiceAccountName(((UmsUserService)userServiceUpdate).getServiceAccountName());
        }
        if (((UmsUserService)userServiceUpdate).getServiceAccountPassword() != null) {
            this.setServiceAccountPassword(((UmsUserService)userServiceUpdate).getServiceAccountPassword());
        }
    }

    @Override
    public UmsUserService clone() {
        return (UmsUserService)super.clone();
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public String getServiceAccountPassword() {
        return this.serviceAccountPassword;
    }

    public void setServiceAccountPassword(String serviceAccountPassword) {
        this.serviceAccountPassword = serviceAccountPassword;
    }
}

