/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.LoginLinkScope;
import com.nuix.automate.utils.models.api.user.UserServiceType;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.models.internal.user.GenericUserService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class UserService
extends UserPermissionModel
implements Cloneable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserService.class);
    protected String id;
    protected String name;
    protected String description;
    protected Boolean enabled;
    protected boolean readOnly;
    protected Status status;
    protected Status warningStatus;
    protected UserServiceType userServiceType;
    private Boolean synchronizeComputers;
    private Boolean synchronizeObjects;
    private Boolean synchronizeUsers;
    private Boolean includeGuestUsers;
    private Boolean includeInactiveUsers;
    private Boolean includeDeletedUsers;
    private Integer searchDelay;
    private Boolean enableCollections;
    protected Boolean enableAuthentication;
    private Boolean usersEligibleLegalHoldAdministrator;
    private Boolean usersEligibleLegalHoldCustodian;
    private Integer objectCount;
    private Long lastSynchronized;
    private String updateMessage;
    private Boolean enableLoginLinks;
    private LoginLinkScope loginLinkScope;
    private Integer loginLinkAutoExpireInterval;
    protected Boolean restrictByUrl;
    protected Set<String> allowedUrls;

    @JsonIgnore
    public boolean isSynchronizeActive() {
        if (Boolean.TRUE.equals(this.getEnabled())) {
            return Boolean.TRUE.equals(this.getSynchronizeUsers()) || Boolean.TRUE.equals(this.getSynchronizeObjects()) || Boolean.TRUE.equals(this.getSynchronizeComputers());
        }
        return false;
    }

    @JsonIgnore
    public boolean isUserSynchronizeActive() {
        return this.getEnabled() == Boolean.TRUE && this.getSynchronizeUsers() == Boolean.TRUE;
    }

    @JsonIgnore
    public boolean isSameScope(UserService userService) {
        return true;
    }

    @JsonIgnore
    public AuthMethodType getAuthMethodType() {
        return AuthMethodType.USERNAME_PASSWORD;
    }

    public void update(UserService userServiceUpdate) {
        if (userServiceUpdate.getName() != null) {
            this.setName(userServiceUpdate.getName().trim());
        }
        if (userServiceUpdate.getDescription() != null) {
            this.setDescription(userServiceUpdate.getDescription().trim());
        }
        if (userServiceUpdate.getEnabled() != null) {
            this.setEnabled(userServiceUpdate.getEnabled());
        }
        if (userServiceUpdate.getSearchDelay() != null) {
            this.setSearchDelay(userServiceUpdate.getSearchDelay());
        }
        if (userServiceUpdate.getSynchronizeComputers() != null) {
            this.setSynchronizeComputers(userServiceUpdate.getSynchronizeComputers());
        }
        if (userServiceUpdate.getEnableAuthentication() != null) {
            this.setEnableAuthentication(userServiceUpdate.getEnableAuthentication());
        }
        if (userServiceUpdate.getRestrictByUrl() != null) {
            this.setRestrictByUrl(userServiceUpdate.getRestrictByUrl());
        }
        if (userServiceUpdate.getAllowedUrls() != null) {
            userServiceUpdate.normalizeAccessUrls();
            TreeSet<String> allowedUrls = new TreeSet<String>(userServiceUpdate.getAllowedUrls());
            this.setAllowedUrls(allowedUrls);
        }
        if (userServiceUpdate.getEnableCollections() != null) {
            this.setEnableCollections(userServiceUpdate.getEnableCollections());
        }
        if (userServiceUpdate.getUsersEligibleLegalHoldAdministrator() != null) {
            this.setUsersEligibleLegalHoldAdministrator(userServiceUpdate.getUsersEligibleLegalHoldAdministrator());
        }
        if (userServiceUpdate.getUsersEligibleLegalHoldCustodian() != null) {
            this.setUsersEligibleLegalHoldCustodian(userServiceUpdate.getUsersEligibleLegalHoldCustodian());
        }
        if (userServiceUpdate.getSynchronizeUsers() != null) {
            this.setSynchronizeUsers(userServiceUpdate.getSynchronizeUsers());
        }
        if (userServiceUpdate.getSynchronizeObjects() != null) {
            this.setSynchronizeObjects(userServiceUpdate.getSynchronizeObjects());
        }
        if (userServiceUpdate.getIncludeGuestUsers() != null) {
            this.setIncludeGuestUsers(userServiceUpdate.getIncludeGuestUsers());
        }
        if (userServiceUpdate.getIncludeInactiveUsers() != null) {
            this.setIncludeInactiveUsers(userServiceUpdate.getIncludeInactiveUsers());
        }
        if (userServiceUpdate.getIncludeDeletedUsers() != null) {
            this.setIncludeDeletedUsers(userServiceUpdate.getIncludeDeletedUsers());
        }
        if (userServiceUpdate.getEnableLoginLinks() != null) {
            this.setEnableLoginLinks(userServiceUpdate.getEnableLoginLinks());
        }
        if (userServiceUpdate.getLoginLinkScope() != null) {
            this.setLoginLinkScope(userServiceUpdate.getLoginLinkScope());
        }
        if (userServiceUpdate.getLoginLinkAutoExpireInterval() != null) {
            this.setLoginLinkAutoExpireInterval(userServiceUpdate.getLoginLinkAutoExpireInterval());
        }
    }

    @Override
    public UserService clone() {
        UserService clone = (UserService)super.clone();
        clone.allowedUrls = new TreeSet<String>();
        if (this.allowedUrls != null) {
            clone.allowedUrls.addAll(this.allowedUrls);
        }
        return clone;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getSearchDelay() {
        return this.searchDelay;
    }

    public void setSearchDelay(Integer searchDelay) {
        this.searchDelay = searchDelay;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getWarningStatus() {
        if (this.warningStatus == null) {
            this.warningStatus = new Status();
        }
        return this.warningStatus;
    }

    public void setWarningStatus(Status warningStatus) {
        this.warningStatus = warningStatus;
    }

    public UserServiceType getUserServiceType() {
        return this.userServiceType;
    }

    public void setUserServiceType(UserServiceType userServiceType) {
        this.userServiceType = userServiceType;
    }

    public Boolean getSynchronizeComputers() {
        return this.synchronizeComputers;
    }

    public void setSynchronizeComputers(Boolean synchronizeComputers) {
        this.synchronizeComputers = synchronizeComputers;
    }

    public Boolean getSynchronizeUsers() {
        return this.synchronizeUsers;
    }

    public void setSynchronizeUsers(Boolean synchronizeUsers) {
        this.synchronizeUsers = synchronizeUsers;
    }

    public Boolean getSynchronizeObjects() {
        return this.synchronizeObjects;
    }

    public void setSynchronizeObjects(Boolean synchronizeObjects) {
        this.synchronizeObjects = synchronizeObjects;
    }

    public Boolean getIncludeGuestUsers() {
        return this.includeGuestUsers;
    }

    public void setIncludeGuestUsers(Boolean includeGuestUsers) {
        this.includeGuestUsers = includeGuestUsers;
    }

    public Boolean getEnableAuthentication() {
        return this.enableAuthentication;
    }

    public void setEnableAuthentication(Boolean enableAuthentication) {
        this.enableAuthentication = true;
    }

    public Boolean getRestrictByUrl() {
        return this.restrictByUrl;
    }

    public void setRestrictByUrl(Boolean restrictByUrl) {
        this.restrictByUrl = restrictByUrl;
    }

    public Set<String> getAllowedUrls() {
        return this.allowedUrls;
    }

    public void setAllowedUrls(Set<String> allowedUrls) {
        this.allowedUrls = allowedUrls;
    }

    @JsonIgnore
    public void internalSetEnableAuthentication(Boolean enableAuthentication) {
        this.enableAuthentication = enableAuthentication;
    }

    public Boolean getEnableCollections() {
        return this.enableCollections;
    }

    public void setEnableCollections(Boolean enableCollections) {
        this.enableCollections = false;
    }

    @JsonIgnore
    public void internalSetEnableCollections(Boolean enableCollections) {
        this.enableCollections = enableCollections;
    }

    public Boolean getUsersEligibleLegalHoldAdministrator() {
        return this.usersEligibleLegalHoldAdministrator;
    }

    public void setUsersEligibleLegalHoldAdministrator(Boolean usersEligibleLegalHoldAdministrator) {
        this.usersEligibleLegalHoldAdministrator = usersEligibleLegalHoldAdministrator;
    }

    public Boolean getUsersEligibleLegalHoldCustodian() {
        return this.usersEligibleLegalHoldCustodian;
    }

    public void setUsersEligibleLegalHoldCustodian(Boolean usersEligibleLegalHoldCustodian) {
        this.usersEligibleLegalHoldCustodian = usersEligibleLegalHoldCustodian;
    }

    public Integer getObjectCount() {
        return this.objectCount;
    }

    public void setObjectCount(Integer objectCount) {
        this.objectCount = objectCount;
    }

    public Long getLastSynchronized() {
        return this.lastSynchronized;
    }

    public void setLastSynchronized(Long lastSynchronized) {
        this.lastSynchronized = lastSynchronized;
    }

    public Boolean getEnableLoginLinks() {
        return this.enableLoginLinks;
    }

    public void setEnableLoginLinks(Boolean enableLoginLinks) {
        this.enableLoginLinks = enableLoginLinks;
    }

    public LoginLinkScope getLoginLinkScope() {
        return this.loginLinkScope;
    }

    public void setLoginLinkScope(LoginLinkScope loginLinkScope) {
        this.loginLinkScope = loginLinkScope;
    }

    public Integer getLoginLinkAutoExpireInterval() {
        return this.loginLinkAutoExpireInterval;
    }

    public void setLoginLinkAutoExpireInterval(Integer loginLinkAutoExpireInterval) {
        this.loginLinkAutoExpireInterval = loginLinkAutoExpireInterval;
    }

    public UserService cloneLimited() {
        GenericUserService limited = new GenericUserService();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.userServiceType = this.userServiceType;
        limited.enableAuthentication = this.enableAuthentication;
        limited.restrictByUrl = this.restrictByUrl;
        limited.allowedUrls = new TreeSet<String>();
        if (this.allowedUrls != null) {
            limited.allowedUrls.addAll(this.allowedUrls);
        }
        limited.readOnly = this.readOnly;
        return limited;
    }

    public void normalize() {
        this.normalizeAccessUrls();
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return "UserService " + (Object)((Object)this.userServiceType) + " " + this.id;
    }

    public String getUpdateMessage() {
        return this.updateMessage;
    }

    public void setUpdateMessage(String updateMessage) {
        this.updateMessage = updateMessage;
    }

    public void setDefaults() {
        if (this.getEnableAuthentication() == null) {
            this.setEnableAuthentication(true);
        }
        if (this.getUsersEligibleLegalHoldAdministrator() == null) {
            this.setUsersEligibleLegalHoldAdministrator(true);
        }
        if (this.getUsersEligibleLegalHoldCustodian() == null) {
            this.setUsersEligibleLegalHoldCustodian(true);
        }
        if (this.getIncludeInactiveUsers() == null) {
            this.setIncludeInactiveUsers(true);
        }
        if (this.getIncludeDeletedUsers() == null) {
            this.setIncludeDeletedUsers(false);
        }
        if (this.getRestrictByUrl() == null) {
            this.setRestrictByUrl(false);
        }
        if (this.getAllowedUrls() == null) {
            this.setAllowedUrls(new HashSet<String>());
        }
    }

    public boolean getEnabledForUserTriggerdAuth() {
        return Boolean.TRUE.equals(this.enabled) && Boolean.TRUE.equals(this.enableAuthentication);
    }

    public Boolean getIncludeInactiveUsers() {
        return this.includeInactiveUsers;
    }

    public void setIncludeInactiveUsers(Boolean includeInactiveUsers) {
        this.includeInactiveUsers = includeInactiveUsers;
    }

    public Boolean getIncludeDeletedUsers() {
        return this.includeDeletedUsers;
    }

    public void setIncludeDeletedUsers(Boolean includeDeletedUsers) {
        this.includeDeletedUsers = includeDeletedUsers;
    }

    public boolean getAvailableForUrl(String accessUrl) {
        if (accessUrl == null) {
            return false;
        }
        try {
            String normalizedAccessUrl = this.normalizeAccessUrl(accessUrl);
            if (Boolean.TRUE.equals(this.getRestrictByUrl())) {
                return this.allowedUrls != null && this.allowedUrls.contains(normalizedAccessUrl);
            }
            return true;
        }
        catch (URISyntaxException e) {
            LOGGER.error("Cannot parse url " + accessUrl, e);
            return false;
        }
    }

    private void normalizeAccessUrls() {
        TreeSet<String> normalizedUrls = new TreeSet<String>();
        if (this.allowedUrls != null) {
            for (String url : this.allowedUrls) {
                try {
                    normalizedUrls.add(this.normalizeAccessUrl(url));
                }
                catch (URISyntaxException e) {
                    LOGGER.error("Cannot parse url " + url, e);
                }
            }
        }
        this.allowedUrls = normalizedUrls;
    }

    private String normalizeAccessUrl(String url) throws URISyntaxException {
        URI uriNoPath;
        String printableUri;
        URI uri = new URI(url.trim());
        if (uri.getHost() == null) {
            uri = new URI(FormattingUtils.getUrlFromHostname(url.trim()));
        }
        if ((printableUri = (uriNoPath = uri.resolve("/")).toString()) != null && printableUri.endsWith("/")) {
            printableUri = printableUri.substring(0, printableUri.length() - 1);
        }
        return printableUri;
    }
}

