/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.vault;

import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.query.AccountInfo;
import com.nuix.automate.utils.models.internal.vault.query.DataScope;
import com.nuix.automate.utils.models.internal.vault.query.DriveOptions;
import com.nuix.automate.utils.models.internal.vault.query.HangoutsChatInfo;
import com.nuix.automate.utils.models.internal.vault.query.HangoutsChatOptions;
import com.nuix.automate.utils.models.internal.vault.query.MailOptions;
import com.nuix.automate.utils.models.internal.vault.query.OrgUnitInfo;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import com.nuix.automate.utils.models.internal.vault.query.SharedDriveInfo;
import com.nuix.automate.utils.models.internal.vault.query.SitesUrlInfo;
import com.nuix.automate.utils.models.internal.vault.query.VoiceOptions;

public class VaultQuery {
    private CorpusType corpus;
    private DataScope dataScope;
    private SearchMethod method;
    private String terms;
    private String startTime;
    private String endTime;
    private String timeZone;
    private AccountInfo accountInfo;
    private OrgUnitInfo orgUnitInfo;
    private HangoutsChatInfo hangoutsChatInfo;
    private SharedDriveInfo sharedDriveInfo;
    private SitesUrlInfo sitesUrlInfo;
    private MailOptions mailOptions;
    private DriveOptions driveOptions;
    private HangoutsChatOptions hangoutsChatOptions;
    private VoiceOptions voiceOptions;

    public CorpusType getCorpus() {
        return this.corpus;
    }

    public void setCorpus(CorpusType corpus) {
        this.corpus = corpus;
    }

    public DataScope getDataScope() {
        return this.dataScope;
    }

    public void setDataScope(DataScope dataScope) {
        this.dataScope = dataScope;
    }

    public SearchMethod getMethod() {
        return this.method;
    }

    public void setMethod(SearchMethod method) {
        this.method = method;
    }

    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public HangoutsChatInfo getHangoutsChatInfo() {
        return this.hangoutsChatInfo;
    }

    public void setHangoutsChatInfo(HangoutsChatInfo hangoutsChatInfo) {
        this.hangoutsChatInfo = hangoutsChatInfo;
    }

    public SharedDriveInfo getSharedDriveInfo() {
        return this.sharedDriveInfo;
    }

    public void setSharedDriveInfo(SharedDriveInfo sharedDriveInfo) {
        this.sharedDriveInfo = sharedDriveInfo;
    }

    public SitesUrlInfo getSitesUrlInfo() {
        return this.sitesUrlInfo;
    }

    public void setSitesUrlInfo(SitesUrlInfo sitesUrlInfo) {
        this.sitesUrlInfo = sitesUrlInfo;
    }

    public MailOptions getMailOptions() {
        return this.mailOptions;
    }

    public void setMailOptions(MailOptions mailOptions) {
        this.mailOptions = mailOptions;
    }

    public DriveOptions getDriveOptions() {
        return this.driveOptions;
    }

    public void setDriveOptions(DriveOptions driveOptions) {
        this.driveOptions = driveOptions;
    }

    public HangoutsChatOptions getHangoutsChatOptions() {
        return this.hangoutsChatOptions;
    }

    public void setHangoutsChatOptions(HangoutsChatOptions hangoutsChatOptions) {
        this.hangoutsChatOptions = hangoutsChatOptions;
    }

    public VoiceOptions getVoiceOptions() {
        return this.voiceOptions;
    }

    public void setVoiceOptions(VoiceOptions voiceOptions) {
        this.voiceOptions = voiceOptions;
    }

    public String toUserPrintableString() {
        String str = "service: " + this.corpus.toLocalizedString() + ", location type: " + this.method.toLocalizedString();
        switch (this.method) {
            case ACCOUNT: {
                str = str + ", email count: " + this.accountInfo.getEmails().size();
                break;
            }
            case ORG_UNIT: {
                str = str + ", org unit: " + this.orgUnitInfo.getOrgUnitId();
                break;
            }
            case SHARED_DRIVE: {
                str = str + ", shared drive count: " + this.sharedDriveInfo.getSharedDriveIds().size();
                break;
            }
            case SITES_URL: {
                str = str + ", sites count: " + this.sitesUrlInfo.getUrls().size();
                break;
            }
            case ROOM: {
                str = str + ", chat space count: " + this.hangoutsChatInfo.getRoomId().size();
            }
        }
        return str;
    }

    public String toString() {
        String str = "Query{corpusType=" + (Object)((Object)this.corpus) + ",method=" + (Object)((Object)this.method) + ",dataScope=" + (Object)((Object)this.dataScope);
        if (this.terms != null) {
            str = str + ",terms=" + this.terms;
        }
        if (this.timeZone != null) {
            str = str + ",timeZone=" + this.timeZone;
        }
        if (this.startTime != null) {
            str = str + ",startTime=" + this.startTime;
        }
        if (this.endTime != null) {
            str = str + ",endTime=" + this.endTime;
        }
        if (this.accountInfo != null) {
            str = str + ",accountInfo=" + this.accountInfo;
        }
        if (this.orgUnitInfo != null) {
            str = str + ",orgUnitInfo=" + this.orgUnitInfo;
        }
        if (this.hangoutsChatInfo != null) {
            str = str + ",hangoutsChatInfo=" + this.hangoutsChatInfo;
        }
        if (this.sitesUrlInfo != null) {
            str = str + ",sitesUrlInfo=" + this.sitesUrlInfo;
        }
        if (this.sharedDriveInfo != null) {
            str = str + ",sharedDriveInfo=" + this.sharedDriveInfo;
        }
        return str + "}";
    }
}

