/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.internal.veritone;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.internal.veritone.VeritoneEngine;

public class VeritoneTranslationEngine
extends VeritoneEngine {
    private String sourceLanguage;
    private String targetLanguage;

    @Override
    public String getKey() {
        return VeritoneTranslationEngine.getKey(this.sourceLanguage, this.targetLanguage);
    }

    @Override
    public void normalize() {
        super.normalize();
        this.sourceLanguage = FormattingUtils.getNonEmptyTrimmedText(this.sourceLanguage);
        this.targetLanguage = FormattingUtils.getNonEmptyTrimmedText(this.targetLanguage);
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.sourceLanguage == null) {
            return false;
        }
        return this.targetLanguage != null;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }
}

