/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(Version.class);
    private int major;
    private int minor;
    private String revision;
    public static final String nullVersion = "0.0.0-null";

    public Version(int major, int minor, String revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public boolean isNull() {
        return this.major == 0 && this.minor == 0 && this.revision.equals("0-null");
    }

    public Version(String version) {
        if (version == null) {
            version = nullVersion;
        }
        String[] splits = version.split("\\.");
        try {
            this.major = Integer.parseInt(splits[0]);
            this.minor = Integer.parseInt(splits[1]);
            if (splits.length >= 3) {
                this.revision = splits[2];
            }
            for (int i = 3; i < splits.length; ++i) {
                this.revision = this.revision + "." + splits[i];
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse version " + version + " to MAJOR.MINOR.REVISION format");
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getRevision() {
        return this.revision;
    }

    public String toMajorMinorString() {
        return this.major + "." + this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }

    @Override
    public int compareTo(@NotNull Version o) {
        if (this.major > o.major) {
            return 1000;
        }
        if (this.major < o.major) {
            return -1000;
        }
        if (this.minor > o.minor) {
            return 100;
        }
        if (this.minor < o.minor) {
            return -100;
        }
        String[] splits = this.revision.split("\\.|-");
        String[] oSplits = o.revision.split("\\.|-");
        int i = 0;
        while (true) {
            String split;
            if (splits.length <= i && oSplits.length <= i) {
                return 0;
            }
            if (splits.length <= i) {
                try {
                    String oSplit = oSplits[i];
                    int n = Integer.parseInt(oSplit);
                }
                catch (NumberFormatException e) {
                    return 1;
                }
                return -1;
            }
            if (oSplits.length <= i) {
                try {
                    split = splits[i];
                    int n = Integer.parseInt(split);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                return 1;
            }
            split = splits[i];
            String oSplit = oSplits[i];
            try {
                int component = Integer.parseInt(split);
                int oComponent = Integer.parseInt(oSplit);
                if (component > oComponent) {
                    return 10;
                }
                if (component < oComponent) {
                    return -10;
                }
            }
            catch (NumberFormatException e) {
                break;
            }
            ++i;
        }
        return this.revision.compareTo(o.revision);
    }
}

