/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=EngineBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindEngine {

    public static class EngineBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                EngineModel arg = (EngineModel)obj;
                q.bind("id", arg.getId());
                q.bind("serverId", arg.getServerId());
                q.bind("name", arg.getName());
                q.bind("nuixLicenceSourceId", arg.getNuixLicenceSourceId());
                q.bind("executionProfileId", arg.getExecutionProfileId());
                q.bind("targetNuixWorkers", arg.getTargetNuixWorkers());
                q.bind("minNuixWorkers", arg.getMinNuixWorkers());
                if (arg.getPriority() != null) {
                    q.bind("priority", arg.getPriority().getInt());
                } else {
                    q.bind("priority", Priority.MEDIUM.getInt());
                }
                q.bind("tags", SerializationUtils.toDbJson(arg.getTags()));
                q.bind("supportedExecutionMode", arg.getSupportedExecutionMode().name());
            };
        }
    }
}

