/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@SqlStatementCustomizingAnnotation(value=RampivaLicenceBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindRampivaLicence {

    public static class RampivaLicenceBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RampivaLicenceBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                AutomateLicenceModel arg = (AutomateLicenceModel)obj;
                q.bind("id", arg.getId());
                AutomateLicenceModel copyModel = null;
                copyModel = arg.clone();
                copyModel.setStatus(null);
                if (copyModel.getCredentials() != null) {
                    try {
                        Credentials credentials = copyModel.getCredentials();
                        String decryptedKey = credentials.getLicenseKey();
                        String encryptedKey = Encryptor.getUserInstance().encrypt(decryptedKey);
                        credentials.setLicenseKey(encryptedKey);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot encrypt Automate access key", e);
                    }
                }
                q.bind("details", SerializationUtils.toDbJson(copyModel));
            };
        }
    }
}

