/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.persistance;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@SqlStatementCustomizingAnnotation(value=UtilizationRecordsBinder.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface BindUtilizationRecords {

    public static class UtilizationRecordsBinder
    implements SqlStatementCustomizerFactory {
        private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UtilizationRecordsBinder.class);

        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            return (q, obj) -> {
                UtilizationRecords arg = (UtilizationRecords)obj;
                q.bind("id", arg.getId());
                q.bind("timestamp", DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                IdEncryptor idEncryptor = new IdEncryptor("utilization");
                String encryptedDetails = null;
                try {
                    encryptedDetails = idEncryptor.encrypt(SerializationUtils.toDbJson(arg));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot encrypt utilization record", e);
                }
                q.bind("details", encryptedDetails);
            };
        }
    }
}

