/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.security;

import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.IdEncryptor;
import com.nuix.automate.utils.security.WinDPAPIEncyptor;
import java.io.IOException;

public abstract class Encryptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Encryptor.class);
    private static Encryptor userInstance;
    private static Encryptor systemInstance;

    public abstract String encrypt(String var1) throws IOException;

    public abstract String decrypt(String var1) throws IOException;

    public boolean test() {
        try {
            String testMessage = UidUtils.getRandom();
            String encryptedMessage = this.encrypt(testMessage);
            String decryptedMessage = this.decrypt(encryptedMessage);
            if (testMessage.equals(decryptedMessage)) {
                LOGGER.warn("Initialized encryptor " + this.getClass());
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot initialize encryptor " + this.getClass(), e);
        }
        return false;
    }

    public static synchronized Encryptor getUserInstance() {
        if (userInstance == null) {
            Encryptor.initializeDefaultEncryptor();
        }
        return userInstance;
    }

    public static synchronized Encryptor getSystemInstance() {
        if (systemInstance == null) {
            Encryptor.initializeDefaultEncryptor();
        }
        return systemInstance;
    }

    public static synchronized Encryptor getWinDpapiEncryptor(boolean localMachine) {
        WinDPAPIEncyptor encryptor = new WinDPAPIEncyptor(true);
        if (!encryptor.test()) {
            throw new IllegalStateException("Cannot test WinDPAPI Encryptor");
        }
        return encryptor;
    }

    public static synchronized void initializeWinDpapiEncryptor() {
        LOGGER.info("Initializing WinDPAPI encryptor");
        userInstance = Encryptor.getWinDpapiEncryptor(false);
        systemInstance = Encryptor.getWinDpapiEncryptor(true);
    }

    public static synchronized Encryptor getIdEncryptor(String id) {
        IdEncryptor encryptor = new IdEncryptor(id);
        if (!encryptor.test()) {
            throw new IllegalStateException("Cannot test ID Encryptor");
        }
        return encryptor;
    }

    public static synchronized void initializeIdEncryptor(String id) {
        LOGGER.info("Initializing ID encryptor");
        systemInstance = userInstance = Encryptor.getIdEncryptor(id);
    }

    public static synchronized Encryptor getIdEncryptor() {
        IdEncryptor encryptor = new IdEncryptor();
        if (!encryptor.test()) {
            throw new IllegalStateException("Cannot test ID Encryptor");
        }
        return encryptor;
    }

    public static synchronized void initializeIdEncryptor() {
        systemInstance = userInstance = Encryptor.getIdEncryptor();
    }

    public static synchronized Encryptor getDefaultEncryptor(boolean localMachine) {
        Encryptor encryptor;
        if (System.getProperty("os.name").contains("Windows") && (encryptor = new WinDPAPIEncyptor(localMachine)).test()) {
            return encryptor;
        }
        encryptor = new IdEncryptor();
        if (encryptor.test()) {
            return encryptor;
        }
        throw new IllegalStateException("Cannot create a suitable Encryptor");
    }

    public static synchronized void initializeDefaultEncryptor() {
        LOGGER.info("Initializing default Encryptor");
        userInstance = Encryptor.getDefaultEncryptor(false);
        systemInstance = Encryptor.getDefaultEncryptor(true);
    }
}

