/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.security;

import com.nuix.automate.utils.general.HashingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.prefs.Preferences;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IdEncryptor
extends Encryptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(IdEncryptor.class);
    private SecretKey key;
    private final SecureRandom secureRandom = new SecureRandom();
    private static final int GCM_IV_LENGTH = 12;

    public IdEncryptor() {
        String instanceId = this.generateId();
        this.setKeyFromId(instanceId);
    }

    public IdEncryptor(String instanceId) {
        if (instanceId == null) {
            instanceId = this.generateId();
        }
        this.setKeyFromId(instanceId);
    }

    private String generateId() {
        Preferences preferences = Preferences.systemRoot().node("/com/rampiva/automate");
        String instanceId = preferences.get("instanceId", null);
        if (instanceId == null) {
            instanceId = UidUtils.getRandom();
            preferences.put("instanceId", instanceId);
        }
        return instanceId;
    }

    private void setKeyFromId(String instanceId) {
        byte[] keyBytes = HashingUtils.digestSha256(instanceId.getBytes(StandardCharsets.UTF_8));
        this.key = new SecretKeySpec(keyBytes, "AES");
    }

    @Override
    public String encrypt(String message) throws IOException {
        if (message == null) {
            return null;
        }
        if (message.length() == 0) {
            return "";
        }
        try {
            String encodedMessage = Base64.getEncoder().encodeToString(message.getBytes(StandardCharsets.UTF_8));
            byte[] utf8 = encodedMessage.getBytes(StandardCharsets.UTF_8);
            byte[] iv = new byte[12];
            this.secureRandom.nextBytes(iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)this.key, parameterSpec);
            byte[] cipherText = cipher.doFinal(utf8);
            ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherText.length);
            byteBuffer.put(iv);
            byteBuffer.put(cipherText);
            return Base64.getEncoder().encodeToString(byteBuffer.array());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String decrypt(String encryptedMessage) throws IOException {
        if (encryptedMessage == null) {
            return null;
        }
        if (encryptedMessage.length() == 0) {
            return "";
        }
        try {
            byte[] dec = Base64.getDecoder().decode(encryptedMessage);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmIv = new GCMParameterSpec(128, dec, 0, 12);
            cipher.init(2, (Key)this.key, gcmIv);
            byte[] utf8 = cipher.doFinal(dec, 12, dec.length - 12);
            String encodedMessage = new String(utf8, StandardCharsets.UTF_8);
            return new String(Base64.getDecoder().decode(encodedMessage), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

