/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.security;

import com.nuix.automate.utils.general.HashingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyEncryptor
extends Encryptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(KeyEncryptor.class);
    private SecretKey key;

    public KeyEncryptor(String instanceId) {
        this.setKeyFromId(instanceId);
    }

    private void setKeyFromId(String instanceId) {
        byte[] keyBytes = HashingUtils.digestSha256(instanceId.getBytes(StandardCharsets.UTF_8));
        this.key = new SecretKeySpec(keyBytes, "AES");
    }

    @Override
    public String encrypt(String message) throws IOException {
        if (message == null) {
            return null;
        }
        if (message.length() == 0) {
            return "";
        }
        byte[] utf8 = message.getBytes("UTF-8");
        try {
            Cipher ecipher = Cipher.getInstance("AES/GCM/NoPadding");
            ecipher.init(1, this.key);
            byte[] enc = ecipher.doFinal(utf8);
            return Base64.getEncoder().encodeToString(enc);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String decrypt(String encryptedMessage) throws IOException {
        if (encryptedMessage == null) {
            return null;
        }
        if (encryptedMessage.length() == 0) {
            return "";
        }
        try {
            byte[] dec = Base64.getDecoder().decode(encryptedMessage);
            Cipher dcipher = Cipher.getInstance("AES/GCM/NoPadding");
            dcipher.init(2, this.key);
            byte[] utf8 = dcipher.doFinal(dec);
            return new String(utf8, StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException(e);
        }
    }
}

