/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.security;

import com.nuix.automate.utils.general.HashingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.Encryptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class LegacyIdEncryptor
extends Encryptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegacyIdEncryptor.class);
    private SecretKey key;

    public LegacyIdEncryptor() {
        String instanceId = this.generateId();
        this.setKeyFromId(instanceId);
    }

    public LegacyIdEncryptor(String instanceId) {
        if (instanceId == null) {
            instanceId = this.generateId();
        }
        this.setKeyFromId(instanceId);
    }

    private String generateId() {
        Preferences preferences = Preferences.systemRoot().node("/com/rampiva/automate");
        String instanceId = preferences.get("instanceId", null);
        if (instanceId == null) {
            instanceId = UidUtils.getRandom();
            preferences.put("instanceId", instanceId);
        }
        return instanceId;
    }

    private void setKeyFromId(String instanceId) {
        byte[] keyBytes = HashingUtils.digestSha256(instanceId.getBytes(StandardCharsets.UTF_8));
        this.key = new SecretKeySpec(keyBytes, "AES");
    }

    @Override
    public String encrypt(String message) throws IOException {
        throw new IOException("Cannot use LegacyIdEncryptor to encrypt new data");
    }

    @Override
    public String decrypt(String encryptedMessage) throws IOException {
        if (encryptedMessage == null) {
            return null;
        }
        if (encryptedMessage.length() == 0) {
            return "";
        }
        try {
            byte[] dec = Base64.getDecoder().decode(encryptedMessage);
            Cipher dcipher = Cipher.getInstance("AES");
            dcipher.init(2, this.key);
            byte[] utf8 = dcipher.doFinal(dec);
            String encodedMessage = new String(utf8, StandardCharsets.UTF_8);
            return new String(Base64.getDecoder().decode(encodedMessage), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

