/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.security;

import com.nuix.automate.utils.general.HashingUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;

public final class SecurityUtils {
    private static final String HMAC_SHA512 = "HmacSHA512";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final SecureRandom random = new SecureRandom();

    public static int getSecureRandomInt() {
        return random.nextInt();
    }

    public static String getSecureRandomSecret() {
        return SecurityUtils.getSecureRandomSecret(32);
    }

    public static String getSecureRandomSecret(int size) {
        return RandomStringUtils.random((int)size, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new SecureRandom());
    }

    public static String getRandomAlphaNumericString(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public static byte[] computeMd5(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        return digest.digest(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String computeMd5Hex(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        return SecurityUtils.toHexString(digest.digest(data));
    }

    public static String computeMd5Hex(String data) throws NoSuchAlgorithmException {
        return SecurityUtils.toHexString(SecurityUtils.computeMd5(data));
    }

    public static byte[] computeSha256(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String computeSha256Hex(String data) throws NoSuchAlgorithmException {
        return SecurityUtils.toHexString(SecurityUtils.computeSha256(data));
    }

    public static String computeShortSha256Hex(String data) {
        try {
            String hash = SecurityUtils.computeSha256Hex(data);
            return hash.substring(0, 8);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte[] computeHmac256(byte[] data, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, HMAC_SHA256);
        Mac mac = Mac.getInstance(HMAC_SHA256);
        mac.init(secretKeySpec);
        return mac.doFinal(data);
    }

    public static byte[] computeHmac(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA512);
        Mac mac = Mac.getInstance(HMAC_SHA512);
        mac.init(secretKeySpec);
        return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String computeHmacHex(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        return SecurityUtils.toHexString(SecurityUtils.computeHmac(data, key));
    }

    public static boolean validateHmac(byte[] hmac, String data, String key) throws InvalidKeyException, NoSuchAlgorithmException {
        return Arrays.equals(hmac, SecurityUtils.computeHmac(data, key));
    }

    private static String toHexString(byte[] bytes) {
        try (Formatter formatter = new Formatter();){
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static String getTokenFromApiSecret(String apiSecret, String instanceId) {
        String plaintext = instanceId + apiSecret;
        return HashingUtils.digestAsHex(plaintext);
    }

    public static String getTokenFromApiSecret(String apiSecret, String instanceId, String nonce) {
        String plaintext = nonce + instanceId + apiSecret;
        return HashingUtils.digestAsHex(plaintext);
    }
}

