/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.sql;

import com.nuix.automate.utils.general.SqlType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.sql.Query;
import com.nuix.automate.utils.sql.UseDriverSqlLocator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;

public class DriverSqlLocator
implements SqlLocator {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DriverSqlLocator.class);
    private final ConcurrentMap<Method, String> located = new ConcurrentHashMap<Method, String>();
    private final SqlType sqlType;

    public DriverSqlLocator(String productName) {
        this.sqlType = this.getStatementForType(productName);
    }

    public String locate(Class<?> sqlObjectType, Method method, ConfigRegistry config) {
        UseDriverSqlLocator useDriverSqlLocatorAnnotation = method.getAnnotation(UseDriverSqlLocator.class);
        if (useDriverSqlLocatorAnnotation != null) {
            Query[] queryAnnotations;
            HashMap<SqlType, String> queries = new HashMap<SqlType, String>();
            for (Query query : queryAnnotations = method.getAnnotation(Query.List.class).value()) {
                queries.put(query.type(), query.query());
            }
            return (String)queries.get((Object)this.sqlType);
        }
        return this.located.computeIfAbsent(method, m -> (String)SqlAnnotations.getAnnotationValue((Method)m).orElseThrow(() -> new IllegalStateException("Sql annotation missing query")));
    }

    private SqlType getStatementForType(String jdbDriverName) {
        switch (jdbDriverName) {
            case "Microsoft SQL Server": {
                return SqlType.MSSQL;
            }
            case "PostgreSQL": {
                return SqlType.POSTGRES;
            }
        }
        return SqlType.SQL_LITE;
    }
}

