/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.utilization.ActivityType;
import java.io.Serializable;
import org.joda.time.DateTime;

public class ActivityDetails
implements Serializable {
    public static final long TIMEOUT = 60000L;
    private long startEpoch;
    private long lastEpoch;
    private String matterId = "";
    private String userId;
    private ActivityType activityType;
    private String activityKey = "";

    public long getStartEpoch() {
        return this.startEpoch;
    }

    public void setStartEpoch(long startEpoch) {
        this.startEpoch = startEpoch;
    }

    public long getLastEpoch() {
        return this.lastEpoch;
    }

    public void setLastEpoch(long lastEpoch) {
        this.lastEpoch = lastEpoch;
    }

    public String getMatterId() {
        if (this.matterId != null) {
            return this.matterId;
        }
        return "";
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getActivityKey() {
        if (this.activityKey != null) {
            return this.activityKey;
        }
        return "";
    }

    public void setActivityKey(String activityKey) {
        this.activityKey = activityKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public String toString() {
        String onMatter = "";
        if (this.matterId != null && this.matterId.length() > 0) {
            onMatter = " on matter " + FormattingUtils.getShortId(this.matterId, 5);
        }
        return "ActivityDetails " + (Object)((Object)this.activityType) + onMatter + " by user " + this.userId + " from " + new DateTime(this.startEpoch).toString() + " to " + new DateTime(this.lastEpoch).toString();
    }

    @JsonIgnore
    public String getKey() {
        return this.userId + "@" + this.matterId + "/" + (Object)((Object)this.activityType);
    }

    @JsonIgnore
    public boolean isExpired(long currentMillis) {
        return currentMillis - this.lastEpoch > 60000L;
    }

    public int hashCode() {
        int hashCode = 7;
        if (this.userId != null) {
            hashCode = this.userId.hashCode();
        }
        hashCode = hashCode * 7 + this.activityType.hashCode();
        hashCode *= 7;
        if (this.matterId != null) {
            hashCode += this.matterId.hashCode();
        }
        hashCode *= 7;
        if (this.activityKey != null) {
            hashCode += this.activityKey.hashCode();
        }
        hashCode = hashCode * 7 + (int)this.startEpoch;
        hashCode = hashCode * 7 + (int)this.lastEpoch;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityDetails o = (ActivityDetails)obj;
        return (this.userId == null && o.userId == null || this.userId != null && o.userId != null && this.userId.equals(o.userId)) && this.activityType.equals((Object)o.activityType) && (this.matterId == null && o.matterId == null || this.matterId != null && o.matterId != null && this.matterId.equals(o.matterId)) && (this.activityKey == null && o.activityKey == null || this.activityKey != null && o.activityKey != null && this.activityKey.equals(o.activityKey)) && this.startEpoch == o.startEpoch && this.lastEpoch == o.lastEpoch;
    }
}

