/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.utilization.Parameter;
import com.nuix.automate.utils.utilization.Priority;
import com.nuix.automate.utils.utilization.Sensitive;
import com.nuix.automate.utils.workflow.ExecutionState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Job
implements Serializable {
    private String jobId;
    private Long jobSubmissionEpoch;
    private Long jobStartEpoch;
    private Long jobEndEpoch;
    private ExecutionState jobExecutionState;
    private double jobPercentageComplete;
    private Boolean jobHasErrors;
    private Boolean jobHasSoftErrors;
    private Boolean jobHasWarnings;
    private String matterId;
    private String resourcePoolId;
    private String executionProfileId;
    private String engineId;
    private String workflowId;
    private Priority jobPriority;
    private boolean excludeMetrics;
    @Sensitive
    private String jobName;
    @Sensitive
    private String jobSubmittedByUserId;
    @Sensitive
    private String jobModifiedByUserId;
    @Sensitive
    private Map<String, String> jobParameters;

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public Long getJobSubmissionEpoch() {
        return this.jobSubmissionEpoch;
    }

    public void setJobSubmissionEpoch(Long jobSubmissionEpoch) {
        this.jobSubmissionEpoch = jobSubmissionEpoch;
    }

    public Long getJobStartEpoch() {
        return this.jobStartEpoch;
    }

    public void setJobStartEpoch(Long jobStartEpoch) {
        this.jobStartEpoch = jobStartEpoch;
    }

    public Long getJobEndEpoch() {
        return this.jobEndEpoch;
    }

    public void setJobEndEpoch(Long jobEndEpoch) {
        this.jobEndEpoch = jobEndEpoch;
    }

    public ExecutionState getJobExecutionState() {
        return this.jobExecutionState;
    }

    public void setJobExecutionState(ExecutionState jobExecutionState) {
        this.jobExecutionState = jobExecutionState;
    }

    public double getJobPercentageComplete() {
        return this.jobPercentageComplete;
    }

    public void setJobPercentageComplete(double jobPercentageComplete) {
        this.jobPercentageComplete = Double.isNaN(jobPercentageComplete) ? 0.0 : jobPercentageComplete;
    }

    public Boolean getJobHasErrors() {
        return this.jobHasErrors;
    }

    public void setJobHasErrors(Boolean jobHasErrors) {
        this.jobHasErrors = jobHasErrors;
    }

    public Boolean getJobHasSoftErrors() {
        return this.jobHasSoftErrors;
    }

    public void setJobHasSoftErrors(Boolean jobHasSoftErrors) {
        this.jobHasSoftErrors = jobHasSoftErrors;
    }

    public Boolean getJobHasWarnings() {
        return this.jobHasWarnings;
    }

    public void setJobHasWarnings(Boolean jobHasWarnings) {
        this.jobHasWarnings = jobHasWarnings;
    }

    public String getJobSubmittedByUserId() {
        return this.jobSubmittedByUserId;
    }

    public void setJobSubmittedByUserId(String jobSubmittedByUserId) {
        this.jobSubmittedByUserId = jobSubmittedByUserId;
    }

    public String getActivityKey() {
        return this.jobId;
    }

    public String getResourcePoolId() {
        return this.resourcePoolId;
    }

    public void setResourcePoolId(String resourcePoolId) {
        this.resourcePoolId = resourcePoolId;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public String getJobModifiedByUserId() {
        return this.jobModifiedByUserId;
    }

    public void setJobModifiedByUserId(String jobModifiedByUserId) {
        this.jobModifiedByUserId = jobModifiedByUserId;
    }

    public Map<String, String> getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(Map<String, String> jobParameters) {
        this.jobParameters = jobParameters;
    }

    @JsonIgnore
    public List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (this.jobParameters != null) {
            for (Map.Entry<String, String> entry : this.jobParameters.entrySet()) {
                Parameter parameter = new Parameter();
                parameter.setJobId(this.jobId);
                parameter.setParameterName(entry.getKey());
                parameter.setParameterValue(entry.getValue());
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    public Priority getJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(Priority jobPriority) {
        this.jobPriority = jobPriority;
    }

    public String getJobSubmissionDate() {
        if (this.jobSubmissionEpoch == null) {
            return null;
        }
        return new DateTime((Object)this.jobSubmissionEpoch).withZone(DateTimeZone.getDefault()).toString();
    }

    public void setJobSubmissionDate(String date) {
    }

    public String getJobStartDate() {
        if (this.jobStartEpoch == null) {
            return null;
        }
        return new DateTime((Object)this.jobStartEpoch).withZone(DateTimeZone.getDefault()).toString();
    }

    public void setJobStartDate(String date) {
    }

    public String getJobEndDate() {
        if (this.jobEndEpoch == null) {
            return null;
        }
        return new DateTime((Object)this.jobEndEpoch).withZone(DateTimeZone.getDefault()).toString();
    }

    public void setJobEnd(String date) {
    }

    public boolean isExcludeMetrics() {
        return this.excludeMetrics;
    }

    public void setExcludeMetrics(boolean excludeMetrics) {
        this.excludeMetrics = excludeMetrics;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public int hashCode() {
        return this.jobId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.jobId.equals(((Job)obj).jobId);
    }
}

