/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization;

import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Session
implements Serializable {
    private String sessionId;
    private String jobId;
    private String licenseId;
    private String productName;
    private String productVersion;
    private String nuixVersion;
    private String nuixLicenseType;
    private String nuixLicenseId;
    private String nuixLicenseOwner;
    private String nuixLicenseFingerprint;
    private String relativityServiceId;
    private long sessionStartEpoch;
    private long sessionEndEpoch;
    private int sessionWorkers;
    private boolean remote;
    private long volumeLoaded;
    private long volumeExported;
    private long volumeOcred;
    private long sessionIdleTimeBeforeExport;
    private long sessionIdleTimeAfterExport;
    private long sessionIdleTimeBeforeLegalExport;
    private long sessionIdleTimeAfterLegalExport;
    private long sessionIdleTimeBeforeNativeExport;
    private long sessionIdleTimeAfterNativeExport;
    private long sessionIdleTimeBeforeOtherExport;
    private long sessionIdleTimeAfterOtherExport;
    private String diagnosticLevel;
    public static Map<String, String> normalizedProductNames = new HashMap<String, String>();

    public String getSessionId() {
        return this.sessionId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public String getSessionStartDate() {
        return new DateTime(this.sessionStartEpoch).withZone(DateTimeZone.getDefault()).toString();
    }

    public void setSessionStartDate(String date) {
    }

    public long getSessionStartEpoch() {
        return this.sessionStartEpoch;
    }

    public void setSessionStartEpoch(long sessionStartEpoch) {
        this.sessionStartEpoch = sessionStartEpoch;
    }

    public String getSessionEndDate() {
        return new DateTime(this.sessionEndEpoch).withZone(DateTimeZone.getDefault()).toString();
    }

    public void setSessionEndDate(String date) {
    }

    public long getSessionEndEpoch() {
        return this.sessionEndEpoch;
    }

    public void setSessionEndEpoch(long sessionEndEpoch) {
        this.sessionEndEpoch = sessionEndEpoch;
    }

    public int getSessionWorkers() {
        return this.sessionWorkers;
    }

    public void setSessionWorkers(int sessionWorkers) {
        this.sessionWorkers = sessionWorkers;
    }

    public String toString() {
        return "Session " + this.sessionId + " from " + this.sessionStartEpoch + " to " + this.sessionEndEpoch + " with " + this.sessionWorkers + " workers";
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getNuixVersion() {
        return this.nuixVersion;
    }

    public void setNuixVersion(String nuixVersion) {
        this.nuixVersion = nuixVersion;
    }

    public String getNuixLicenseType() {
        return this.nuixLicenseType;
    }

    public void setNuixLicenseType(String nuixLicenseType) {
        this.nuixLicenseType = nuixLicenseType;
    }

    public String getNuixLicenseId() {
        return this.nuixLicenseId;
    }

    public void setNuixLicenseId(String nuixLicenseId) {
        this.nuixLicenseId = nuixLicenseId;
    }

    public String getNuixLicenseOwner() {
        return this.nuixLicenseOwner;
    }

    public void setNuixLicenseOwner(String nuixLicenseOwner) {
        this.nuixLicenseOwner = nuixLicenseOwner;
    }

    public String getNuixLicenseFingerprint() {
        return this.nuixLicenseFingerprint;
    }

    public void setNuixLicenseFingerprint(String nuixLicenseFingerprint) {
        this.nuixLicenseFingerprint = nuixLicenseFingerprint;
    }

    public String getRelativityServiceId() {
        return this.relativityServiceId;
    }

    public void setRelativityServiceId(String relativityServiceId) {
        this.relativityServiceId = relativityServiceId;
    }

    public long getVolumeLoaded() {
        return this.volumeLoaded;
    }

    public void setVolumeLoaded(long volumeLoaded) {
        this.volumeLoaded = volumeLoaded;
    }

    public long getVolumeExported() {
        return this.volumeExported;
    }

    public void setVolumeExported(long volumeExported) {
        this.volumeExported = volumeExported;
    }

    public long getVolumeOcred() {
        return this.volumeOcred;
    }

    public void setVolumeOcred(long volumeOcred) {
        this.volumeOcred = volumeOcred;
    }

    public boolean getRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public String getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public void setDiagnosticLevel(String diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel;
    }

    public void setDiagnosticLevel(DiagnosticLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel.name();
    }

    public long getSessionIdleTimeBeforeExport() {
        return this.sessionIdleTimeBeforeExport;
    }

    public void setSessionIdleTimeBeforeExport(long sessionIdleTimeBeforeExport) {
        this.sessionIdleTimeBeforeExport = sessionIdleTimeBeforeExport;
    }

    public long getSessionIdleTimeBeforeLegalExport() {
        return this.sessionIdleTimeBeforeLegalExport;
    }

    public void setSessionIdleTimeBeforeLegalExport(long sessionIdleTimeBeforeLegalExport) {
        this.sessionIdleTimeBeforeLegalExport = sessionIdleTimeBeforeLegalExport;
    }

    public long getSessionIdleTimeAfterLegalExport() {
        return this.sessionIdleTimeAfterLegalExport;
    }

    public void setSessionIdleTimeAfterLegalExport(long sessionIdleTimeAfterLegalExport) {
        this.sessionIdleTimeAfterLegalExport = sessionIdleTimeAfterLegalExport;
    }

    public long getSessionIdleTimeBeforeNativeExport() {
        return this.sessionIdleTimeBeforeNativeExport;
    }

    public void setSessionIdleTimeBeforeNativeExport(long sessionIdleTimeBeforeNativeExport) {
        this.sessionIdleTimeBeforeNativeExport = sessionIdleTimeBeforeNativeExport;
    }

    public long getSessionIdleTimeAfterNativeExport() {
        return this.sessionIdleTimeAfterNativeExport;
    }

    public void setSessionIdleTimeAfterNativeExport(long sessionIdleTimeAfterNativeExport) {
        this.sessionIdleTimeAfterNativeExport = sessionIdleTimeAfterNativeExport;
    }

    public long getSessionIdleTimeAfterExport() {
        return this.sessionIdleTimeAfterExport;
    }

    public void setSessionIdleTimeAfterExport(long sessionIdleTimeAfterExport) {
        this.sessionIdleTimeAfterExport = sessionIdleTimeAfterExport;
    }

    public long getSessionIdleTimeBeforeOtherExport() {
        return this.sessionIdleTimeBeforeOtherExport;
    }

    public void setSessionIdleTimeBeforeOtherExport(long sessionIdleTimeBeforeOtherExport) {
        this.sessionIdleTimeBeforeOtherExport = sessionIdleTimeBeforeOtherExport;
    }

    public long getSessionIdleTimeAfterOtherExport() {
        return this.sessionIdleTimeAfterOtherExport;
    }

    public void setSessionIdleTimeAfterOtherExport(long sessionIdleTimeAfterOtherExport) {
        this.sessionIdleTimeAfterOtherExport = sessionIdleTimeAfterOtherExport;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.sessionId.equals(((Session)obj).sessionId);
    }

    public void normalize() {
        String normalizedProductName;
        if (this.productVersion != null && this.productVersion.endsWith("-Standalone") && !this.productVersion.startsWith("via ")) {
            this.productVersion = "via UE " + this.productVersion;
        }
        if ((normalizedProductName = normalizedProductNames.get(this.productName)) != null) {
            this.productName = normalizedProductName;
        }
    }

    static {
        normalizedProductNames.put("WORKFLOW", "Automate Workflow");
        normalizedProductNames.put(Product.WORKFLOW.name(), "Automate Workflow");
        normalizedProductNames.put("SCHEDULER", "Automate Scheduler");
        normalizedProductNames.put(Product.SCHEDULER.name(), "Automate Scheduler");
        normalizedProductNames.put("ENGINE", "Automate Engine");
        normalizedProductNames.put(Product.ENGINE.name(), "Automate Engine");
        normalizedProductNames.put("UE-Manual", "Nuix");
        normalizedProductNames.put("UE-Automated", "Automate Workflow");
        normalizedProductNames.put("UE", "Nuix");
    }
}

