/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.security.Encryptor;
import com.nuix.automate.utils.security.KeyEncryptor;
import com.nuix.automate.utils.utilization.Activity;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.Collection;
import com.nuix.automate.utils.utilization.CollectionTarget;
import com.nuix.automate.utils.utilization.CustodianActivity;
import com.nuix.automate.utils.utilization.CustodianNotice;
import com.nuix.automate.utils.utilization.DataRepository;
import com.nuix.automate.utils.utilization.DataSet;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.LegalHold;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.License;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.Notice;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.NuixCaseStat;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.Organization;
import com.nuix.automate.utils.utilization.RelativityWorkspace;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.TransferVolume;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationProperty;
import com.nuix.automate.utils.utilization.Workflow;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UtilizationRecords
implements Cloneable,
Serializable {
    private String id;
    private Set<Client> clients;
    private Set<DataRepository> dataRepositories;
    private Set<DataSet> dataSets;
    private Set<Transfer> transfers;
    private Set<TransferVolume> transferVolumes;
    private Set<Engine> engines;
    private Set<ExecutionProfile> executionProfiles;
    private Set<Job> jobs;
    private Set<Library> libraries;
    private Set<Matter> matters;
    private Set<NuixCase> nuixCases;
    private Set<RelativityWorkspace> relativityWorkspaces;
    private Set<Operation> operations;
    private Set<ResourcePool> resourcePools;
    private Set<Server> servers;
    private Set<Session> sessions;
    private Set<Workflow> workflows;
    private Set<User> users;
    private Set<ActivityDetails> activityDetails;
    private Set<Activity> activities;
    private List<NuixCaseStat> nuixCaseStats;
    private Set<License> licenses;
    private Set<Organization> organizations;
    private Set<Collection> collections;
    private Set<CollectionTarget> collectionTargets;
    private Set<LegalHold> legalHolds;
    private Set<Notice> notices;
    private Set<CustodianNotice> custodianNotices;
    private Set<CustodianActivity> custodianActivities;
    private Set<ConsumptionEvent> consumptionEvents;
    private Map<String, String> properties;

    public UtilizationRecords clone() {
        Gson gson = new Gson();
        return (UtilizationRecords)gson.fromJson(gson.toJson((Object)this), UtilizationRecords.class);
    }

    public Set<Client> getClients() {
        return this.clients;
    }

    public void setClients(Set<Client> clients) {
        this.clients = clients;
    }

    public Set<DataRepository> getDataRepositories() {
        return this.dataRepositories;
    }

    public void setDataRepositories(Set<DataRepository> dataRepositories) {
        this.dataRepositories = dataRepositories;
    }

    public Set<DataSet> getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(Set<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public Set<Engine> getEngines() {
        return this.engines;
    }

    public void setEngines(Set<Engine> engines) {
        this.engines = engines;
    }

    public Set<ExecutionProfile> getExecutionProfiles() {
        return this.executionProfiles;
    }

    public void setExecutionProfiles(Set<ExecutionProfile> executionProfiles) {
        this.executionProfiles = executionProfiles;
    }

    public Set<Job> getJobs() {
        return this.jobs;
    }

    public void setJobs(Set<Job> jobs) {
        this.jobs = jobs;
    }

    public Set<Library> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(Set<Library> libraries) {
        this.libraries = libraries;
    }

    public Set<Matter> getMatters() {
        return this.matters;
    }

    public void setMatters(Set<Matter> matters) {
        this.matters = matters;
    }

    public Set<NuixCase> getNuixCases() {
        return this.nuixCases;
    }

    public void setNuixCases(Set<NuixCase> nuixCases) {
        this.nuixCases = nuixCases;
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(Set<Operation> operations) {
        this.operations = operations;
    }

    public Set<ResourcePool> getResourcePools() {
        return this.resourcePools;
    }

    public void setResourcePools(Set<ResourcePool> resourcePools) {
        this.resourcePools = resourcePools;
    }

    public Set<Server> getServers() {
        return this.servers;
    }

    public void setServers(Set<Server> servers) {
        this.servers = servers;
    }

    public Set<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<Session> sessions) {
        this.sessions = sessions;
    }

    public Set<Workflow> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(Set<Workflow> workflows) {
        this.workflows = workflows;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        if (this.id == null) {
            return "NoID " + this.toUserFriendlyString();
        }
        return this.id + " " + this.toUserFriendlyString();
    }

    public Set<ActivityDetails> getActivityDetails() {
        return this.activityDetails;
    }

    public void setActivityDetails(Set<ActivityDetails> activityDetails) {
        this.activityDetails = activityDetails;
    }

    public List<NuixCaseStat> getNuixCaseStats() {
        return this.nuixCaseStats;
    }

    public void setNuixCaseStats(List<NuixCaseStat> nuixCaseStats) {
        this.nuixCaseStats = nuixCaseStats;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(Set<License> licenses) {
        this.licenses = licenses;
    }

    public Set<Organization> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(Set<Organization> organizations) {
        this.organizations = organizations;
    }

    public Set<Collection> getCollections() {
        return this.collections;
    }

    public void setCollections(Set<Collection> collections) {
        this.collections = collections;
    }

    public Set<CollectionTarget> getCollectionTargets() {
        return this.collectionTargets;
    }

    public void setCollectionTargets(Set<CollectionTarget> collectionTargets) {
        this.collectionTargets = collectionTargets;
    }

    public Set<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<Activity> activities) {
        this.activities = activities;
    }

    public Set<Transfer> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(Set<Transfer> transfers) {
        this.transfers = transfers;
    }

    public Set<TransferVolume> getTransferVolumes() {
        return this.transferVolumes;
    }

    public void setTransferVolumes(Set<TransferVolume> transferVolumes) {
        this.transferVolumes = transferVolumes;
    }

    public Set<LegalHold> getLegalHolds() {
        return this.legalHolds;
    }

    public void setLegalHolds(Set<LegalHold> legalHolds) {
        this.legalHolds = legalHolds;
    }

    public Set<Notice> getNotices() {
        return this.notices;
    }

    public void setNotices(Set<Notice> notices) {
        this.notices = notices;
    }

    public Set<CustodianNotice> getCustodianNotices() {
        return this.custodianNotices;
    }

    public void setCustodianNotices(Set<CustodianNotice> custodianNotices) {
        this.custodianNotices = custodianNotices;
    }

    public Set<CustodianActivity> getCustodianActivities() {
        return this.custodianActivities;
    }

    public void setCustodianActivities(Set<CustodianActivity> custodianActivities) {
        this.custodianActivities = custodianActivities;
    }

    public Set<ConsumptionEvent> getConsumptionEvents() {
        return this.consumptionEvents;
    }

    public void setConsumptionEvents(Set<ConsumptionEvent> consumptionEvents) {
        this.consumptionEvents = consumptionEvents;
    }

    public void encryptSensitiveProperties(String encryptionKey, DiagnosticLevel diagnosticLevel, boolean replaceNamesWithIds) throws IOException {
        boolean diagnosticLevelOptional;
        UtilizationRecords utilizationRecords = this;
        if (encryptionKey != null && encryptionKey.length() == 0) {
            encryptionKey = null;
        }
        KeyEncryptor encryptor = null;
        if (encryptionKey != null) {
            encryptor = new KeyEncryptor(encryptionKey);
        }
        boolean bl = diagnosticLevelOptional = diagnosticLevel != null && diagnosticLevel.equals((Object)DiagnosticLevel.OPTIONAL) && encryptionKey != null && encryptionKey.length() > 0;
        if (utilizationRecords.getClients() != null) {
            for (Client client : utilizationRecords.getClients()) {
                if (replaceNamesWithIds) {
                    client.setClientName(Client.class.getSimpleName() + " " + FormattingUtils.getShortId(client.getClientId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    client.setClientName(((Encryptor)encryptor).encrypt(client.getClientName()));
                    continue;
                }
                client.setClientName(null);
            }
        }
        if (utilizationRecords.getDataRepositories() != null) {
            for (DataRepository dataRepository : utilizationRecords.getDataRepositories()) {
                if (replaceNamesWithIds) {
                    dataRepository.setDataRepositoryName(DataRepository.class.getSimpleName() + " " + FormattingUtils.getShortId(dataRepository.getDataRepositoryId()));
                    dataRepository.setDataRepositoryLocation("C:\\Temp\\" + DataRepository.class.getSimpleName() + " " + FormattingUtils.getShortId(dataRepository.getDataRepositoryId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    dataRepository.setDataRepositoryName(((Encryptor)encryptor).encrypt(dataRepository.getDataRepositoryName()));
                    dataRepository.setDataRepositoryLocation(((Encryptor)encryptor).encrypt(dataRepository.getDataRepositoryLocation()));
                    continue;
                }
                dataRepository.setDataRepositoryName(null);
                dataRepository.setDataRepositoryLocation(null);
            }
        }
        if (utilizationRecords.getDataSets() != null) {
            for (DataSet dataSet : utilizationRecords.getDataSets()) {
                if (replaceNamesWithIds) {
                    dataSet.setDataSetName(DataSet.class.getSimpleName() + " " + FormattingUtils.getShortId(dataSet.getDataSetId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    dataSet.setDataSetName(((Encryptor)encryptor).encrypt(dataSet.getDataSetName()));
                    continue;
                }
                dataSet.setDataSetName(null);
            }
        }
        if (utilizationRecords.getEngines() != null) {
            for (Engine engine : utilizationRecords.getEngines()) {
                if (replaceNamesWithIds) {
                    engine.setEngineName(Engine.class.getSimpleName() + " " + FormattingUtils.getShortId(engine.getEngineId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    engine.setEngineName(((Encryptor)encryptor).encrypt(engine.getEngineName()));
                    continue;
                }
                engine.setEngineName(null);
            }
        }
        if (utilizationRecords.getExecutionProfiles() != null) {
            for (ExecutionProfile executionProfile : utilizationRecords.getExecutionProfiles()) {
                if (replaceNamesWithIds) {
                    executionProfile.setExecutionProfileName(ExecutionProfile.class.getSimpleName() + " " + FormattingUtils.getShortId(executionProfile.getExecutionProfileId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    executionProfile.setExecutionProfileName(((Encryptor)encryptor).encrypt(executionProfile.getExecutionProfileName()));
                    continue;
                }
                executionProfile.setExecutionProfileName(null);
            }
        }
        if (utilizationRecords.getJobs() != null) {
            for (Job job : utilizationRecords.getJobs()) {
                if (replaceNamesWithIds) {
                    if (!job.getJobName().equals("Automated Job") && !job.getJobName().equals("Manual Job")) {
                        job.setJobName(Job.class.getSimpleName() + " " + FormattingUtils.getShortId(job.getJobId()));
                    }
                    job.setJobParameters(null);
                    continue;
                }
                if (diagnosticLevelOptional) {
                    job.setJobName(((Encryptor)encryptor).encrypt(job.getJobName()));
                    Map<String, String> parameters = job.getJobParameters();
                    if (parameters == null) continue;
                    HashMap<String, String> encryptedParameters = new HashMap<String, String>();
                    for (Map.Entry<String, String> entry : parameters.entrySet()) {
                        String encryptedName = ((Encryptor)encryptor).encrypt(entry.getKey());
                        String encryptedValue = ((Encryptor)encryptor).encrypt(entry.getValue());
                        encryptedParameters.put(encryptedName, encryptedValue);
                    }
                    job.setJobParameters(encryptedParameters);
                    continue;
                }
                job.setJobName(null);
                job.setJobParameters(null);
            }
        }
        if (utilizationRecords.getCollections() != null) {
            for (Collection collection : utilizationRecords.getCollections()) {
                if (replaceNamesWithIds) {
                    collection.setCollectionName(Collection.class.getSimpleName() + " " + FormattingUtils.getShortId(collection.getCollectionId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    collection.setCollectionName(((Encryptor)encryptor).encrypt(collection.getCollectionName()));
                    Map<String, String> settings = collection.getCollectionSettings();
                    if (settings == null) continue;
                    HashMap<String, String> encryptedSettings = new HashMap<String, String>();
                    for (Map.Entry<String, String> entry : settings.entrySet()) {
                        String encryptedValue = ((Encryptor)encryptor).encrypt(entry.getValue());
                        encryptedSettings.put(entry.getKey(), encryptedValue);
                    }
                    collection.setCollectionSettings(encryptedSettings);
                    continue;
                }
                collection.setCollectionName(null);
                collection.setCollectionSettings(null);
            }
        }
        if (utilizationRecords.getCollectionTargets() != null) {
            for (CollectionTarget collectionTarget : utilizationRecords.getCollectionTargets()) {
                if (replaceNamesWithIds) {
                    collectionTarget.setTargetName(CollectionTarget.class.getSimpleName() + " " + FormattingUtils.getShortId(collectionTarget.getCollectionId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    collectionTarget.setTargetName(((Encryptor)encryptor).encrypt(collectionTarget.getTargetName()));
                    continue;
                }
                collectionTarget.setTargetName(null);
            }
        }
        if (utilizationRecords.getUsers() != null) {
            for (User user : utilizationRecords.getUsers()) {
                if (replaceNamesWithIds) {
                    user.setUserName(User.class.getSimpleName() + " " + FormattingUtils.getShortId(user.getUserId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    user.setUserName(((Encryptor)encryptor).encrypt(user.getUserName()));
                    continue;
                }
                user.setUserName(null);
            }
        }
        if (utilizationRecords.getLibraries() != null) {
            for (Library library : utilizationRecords.getLibraries()) {
                if (replaceNamesWithIds) {
                    library.setLibraryName(Library.class.getSimpleName() + " " + FormattingUtils.getShortId(library.getLibraryId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    library.setLibraryName(((Encryptor)encryptor).encrypt(library.getLibraryName()));
                    continue;
                }
                library.setLibraryName(null);
            }
        }
        if (utilizationRecords.getMatters() != null) {
            for (Matter matter : utilizationRecords.getMatters()) {
                if (replaceNamesWithIds) {
                    matter.setMatterName(Matter.class.getSimpleName() + " " + FormattingUtils.getShortId(matter.getMatterId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    matter.setMatterName(((Encryptor)encryptor).encrypt(matter.getMatterName()));
                    continue;
                }
                matter.setMatterName(null);
            }
        }
        if (utilizationRecords.getNuixCases() != null) {
            for (NuixCase nuixCase : utilizationRecords.getNuixCases()) {
                if (replaceNamesWithIds) {
                    nuixCase.setNuixCaseName(NuixCase.class.getSimpleName() + " " + FormattingUtils.getShortId(nuixCase.getNuixCaseId()));
                    nuixCase.setNuixCaseLocation("C:\\Temp\\" + NuixCase.class.getSimpleName() + " " + FormattingUtils.getShortId(nuixCase.getNuixCaseId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    nuixCase.setNuixCaseName(((Encryptor)encryptor).encrypt(nuixCase.getNuixCaseName()));
                    nuixCase.setNuixCaseLocation(((Encryptor)encryptor).encrypt(nuixCase.getNuixCaseLocation()));
                    continue;
                }
                nuixCase.setNuixCaseName(null);
                nuixCase.setNuixCaseLocation(null);
            }
        }
        if (utilizationRecords.getRelativityWorkspaces() != null) {
            for (RelativityWorkspace relativityWorkspace : utilizationRecords.getRelativityWorkspaces()) {
                if (replaceNamesWithIds) {
                    relativityWorkspace.setRelativityWorkspaceName(RelativityWorkspace.class.getSimpleName() + " " + FormattingUtils.getShortId("" + relativityWorkspace.getRelativityWorkspaceArtifactId().hashCode()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    relativityWorkspace.setRelativityWorkspaceName(((Encryptor)encryptor).encrypt(relativityWorkspace.getRelativityWorkspaceName()));
                    continue;
                }
                relativityWorkspace.setRelativityWorkspaceName(null);
            }
        }
        if (utilizationRecords.getResourcePools() != null) {
            for (ResourcePool resourcePool : utilizationRecords.getResourcePools()) {
                if (replaceNamesWithIds) {
                    resourcePool.setResourcePoolName(ResourcePool.class.getSimpleName() + " " + FormattingUtils.getShortId(resourcePool.getResourcePoolId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    resourcePool.setResourcePoolName(((Encryptor)encryptor).encrypt(resourcePool.getResourcePoolName()));
                    continue;
                }
                resourcePool.setResourcePoolName(null);
            }
        }
        if (utilizationRecords.getServers() != null) {
            for (Server server : utilizationRecords.getServers()) {
                if (replaceNamesWithIds) {
                    server.setServerName(Server.class.getSimpleName() + " " + FormattingUtils.getShortId(server.getServerId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    server.setServerName(((Encryptor)encryptor).encrypt(server.getServerName()));
                    continue;
                }
                server.setServerName(null);
            }
        }
        if (utilizationRecords.getWorkflows() != null) {
            for (Workflow workflow : utilizationRecords.getWorkflows()) {
                if (replaceNamesWithIds) {
                    workflow.setWorkflowName(Workflow.class.getSimpleName() + " " + FormattingUtils.getShortId(workflow.getWorkflowId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    workflow.setWorkflowName(((Encryptor)encryptor).encrypt(workflow.getWorkflowName()));
                    continue;
                }
                workflow.setWorkflowName(null);
            }
        }
        if (utilizationRecords.getNuixCaseStats() != null) {
            List<NuixCaseStat> nuixCaseStats = utilizationRecords.getNuixCaseStats();
            HashMap<String, Long> metricCount = new HashMap<String, Long>();
            for (NuixCaseStat nuixCaseStat : nuixCaseStats) {
                if (nuixCaseStat.getMetricType().equals("Month")) continue;
                if (replaceNamesWithIds) {
                    nuixCaseStat.setMetricValue(nuixCaseStat.getMetricType() + " " + FormattingUtils.getShortId(UidUtils.fromString(nuixCaseStat.getMetricValue()).toString()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    nuixCaseStat.setMetricValue(((Encryptor)encryptor).encrypt(nuixCaseStat.getMetricValue()));
                    continue;
                }
                Long count = (Long)metricCount.get(nuixCaseStat.getMetricType());
                if (count == null) {
                    count = 0L;
                }
                Long l = count;
                count = count + 1L;
                metricCount.put(nuixCaseStat.getMetricType(), count);
                nuixCaseStat.setMetricValue(nuixCaseStat.getMetricType() + " " + count);
            }
        }
        if (utilizationRecords.getLicenses() != null) {
            for (License license : utilizationRecords.getLicenses()) {
                if (replaceNamesWithIds) {
                    license.setLicenseName(License.class.getSimpleName() + " " + FormattingUtils.getShortId(license.getLicenseId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    license.setLicenseName(((Encryptor)encryptor).encrypt(license.getLicenseName()));
                    continue;
                }
                license.setLicenseName(null);
            }
        }
        if (utilizationRecords.getOrganizations() != null) {
            for (Organization organization : utilizationRecords.getOrganizations()) {
                if (replaceNamesWithIds) {
                    organization.setOrganizationName(Organization.class.getSimpleName() + " " + FormattingUtils.getShortId(organization.getOrganizationId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    organization.setOrganizationName(((Encryptor)encryptor).encrypt(organization.getOrganizationName()));
                    continue;
                }
                organization.setOrganizationName(null);
            }
        }
        if (utilizationRecords.getOperations() != null) {
            for (Operation operation : utilizationRecords.getOperations()) {
                UtilizationRecords operationUtilizationRecords = operation.getUtilizationRecords();
                if (operationUtilizationRecords == null) continue;
                operationUtilizationRecords.encryptSensitiveProperties(encryptionKey, diagnosticLevel, replaceNamesWithIds);
            }
        }
        if (utilizationRecords.getLegalHolds() != null) {
            for (LegalHold legalHold : utilizationRecords.getLegalHolds()) {
                if (replaceNamesWithIds) {
                    legalHold.setLegalHoldName(LegalHold.class.getSimpleName() + " " + FormattingUtils.getShortId(legalHold.getLegalHoldId()));
                    continue;
                }
                if (diagnosticLevelOptional) {
                    legalHold.setLegalHoldName(((Encryptor)encryptor).encrypt(legalHold.getLegalHoldName()));
                    continue;
                }
                legalHold.setLegalHoldName(null);
            }
        }
    }

    public List<UtilizationRecords> split() {
        return this.split(16);
    }

    public List<UtilizationRecords> split(int maxRecords) {
        String previousNotes;
        int count;
        UtilizationRecords component;
        ArrayList<UtilizationRecords> results = new ArrayList<UtilizationRecords>();
        if (this.consumptionEvents != null) {
            component = null;
            count = 0;
            for (ConsumptionEvent consumptionEvent : this.consumptionEvents) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setConsumptionEvents(new HashSet<ConsumptionEvent>());
                    results.add(component);
                    component.setId(this.id + "-" + consumptionEvent.getConsumptionEventId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Consumption " + results.size() + previousNotes);
                }
                component.getConsumptionEvents().add(consumptionEvent);
                ++count;
            }
        }
        if (this.clients != null) {
            component = null;
            count = 0;
            for (Client client : this.clients) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setClients(new HashSet<Client>());
                    results.add(component);
                    component.setId(this.id + "-" + client.getClientId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Client " + results.size() + previousNotes);
                }
                component.getClients().add(client);
                ++count;
            }
        }
        if (this.dataRepositories != null) {
            component = null;
            count = 0;
            for (DataRepository dataRepository : this.dataRepositories) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setDataRepositories(new HashSet<DataRepository>());
                    results.add(component);
                    component.setId(this.id + "-" + dataRepository.getDataRepositoryId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Data Repository " + results.size() + previousNotes);
                }
                component.getDataRepositories().add(dataRepository);
                ++count;
            }
        }
        if (this.dataSets != null) {
            component = null;
            count = 0;
            for (DataSet dataSet : this.dataSets) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setDataSets(new HashSet<DataSet>());
                    results.add(component);
                    component.setId(this.id + "-" + dataSet.getDataSetId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "DataSet " + results.size() + previousNotes);
                }
                component.getDataSets().add(dataSet);
                ++count;
            }
        }
        if (this.transfers != null) {
            component = null;
            count = 0;
            for (Transfer transfer : this.transfers) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setTransfers(new HashSet<Transfer>());
                    results.add(component);
                    component.setId(this.id + "-" + transfer.getTransferId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Transfer " + results.size() + previousNotes);
                }
                component.getTransfers().add(transfer);
                ++count;
            }
        }
        if (this.transferVolumes != null) {
            component = null;
            count = 0;
            for (TransferVolume transferVolume : this.transferVolumes) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setTransferVolumes(new HashSet<TransferVolume>());
                    results.add(component);
                    component.setId(this.id + "-" + transferVolume.getTransferId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "TransferVolume " + results.size() + previousNotes);
                }
                component.getTransferVolumes().add(transferVolume);
                ++count;
            }
        }
        if (this.engines != null) {
            component = null;
            count = 0;
            for (Engine engine : this.engines) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setEngines(new HashSet<Engine>());
                    results.add(component);
                    component.setId(this.id + "-" + engine.getEngineId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Engine " + results.size() + previousNotes);
                }
                component.getEngines().add(engine);
                ++count;
            }
        }
        if (this.executionProfiles != null) {
            component = null;
            count = 0;
            for (ExecutionProfile executionProfile : this.executionProfiles) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setExecutionProfiles(new HashSet<ExecutionProfile>());
                    results.add(component);
                    component.setId(this.id + "-" + executionProfile.getExecutionProfileId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "ExecutionProfile " + results.size() + previousNotes);
                }
                component.getExecutionProfiles().add(executionProfile);
                ++count;
            }
        }
        if (this.jobs != null) {
            component = null;
            count = 0;
            for (Job job : this.jobs) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setJobs(new HashSet<Job>());
                    results.add(component);
                    component.setId(this.id + "-" + job.getJobId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Job " + results.size() + previousNotes);
                }
                component.getJobs().add(job);
                ++count;
            }
        }
        if (this.libraries != null) {
            component = null;
            count = 0;
            for (Library library : this.libraries) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setLibraries(new HashSet<Library>());
                    component.setId(this.id + "-" + library.getLibraryId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Library " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getLibraries().add(library);
                ++count;
            }
        }
        if (this.matters != null) {
            component = null;
            count = 0;
            for (Matter matter : this.matters) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setMatters(new HashSet<Matter>());
                    component.setId(this.id + "-" + matter.getMatterId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Matter " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getMatters().add(matter);
                ++count;
            }
        }
        if (this.nuixCases != null) {
            component = null;
            count = 0;
            for (NuixCase nuixCase : this.nuixCases) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setNuixCases(new HashSet<NuixCase>());
                    component.setId(this.id + "-" + nuixCase.getNuixCaseId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "NuixCase " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getNuixCases().add(nuixCase);
                ++count;
            }
        }
        if (this.relativityWorkspaces != null) {
            component = null;
            count = 0;
            for (RelativityWorkspace relativityWorkspace : this.relativityWorkspaces) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setNuixCases(new HashSet<NuixCase>());
                    component.setId(this.id + "-" + relativityWorkspace.getRelativityWorkspaceArtifactId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "RelativityWorkspace " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getRelativityWorkspaces().add(relativityWorkspace);
                ++count;
            }
        }
        if (this.operations != null) {
            component = null;
            count = 0;
            for (Operation operation : this.operations) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setOperations(new HashSet<Operation>());
                    component.setId(this.id + "-" + operation.getOperationId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Operation " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getOperations().add(operation);
                if (operation.getOperationSettings() != null) {
                    count += operation.getOperationSettings().size() / 5;
                }
                if (operation.getMimeTypeVolumes() != null) {
                    count += operation.getMimeTypeVolumes().size() / 5;
                }
                ++count;
            }
        }
        if (this.resourcePools != null) {
            component = null;
            count = 0;
            for (ResourcePool resourcePool : this.resourcePools) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setResourcePools(new HashSet<ResourcePool>());
                    component.setId(this.id + "-" + resourcePool.getResourcePoolId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "ResourcePool " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getResourcePools().add(resourcePool);
                ++count;
            }
        }
        if (this.servers != null) {
            component = null;
            count = 0;
            for (Server server : this.servers) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setServers(new HashSet<Server>());
                    component.setId(this.id + "-" + server.getServerId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Server " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getServers().add(server);
                ++count;
            }
        }
        if (this.sessions != null) {
            component = null;
            count = 0;
            for (Session session : this.sessions) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setSessions(new HashSet<Session>());
                    component.setId(this.id + "-" + session.getSessionId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Session " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getSessions().add(session);
                ++count;
            }
        }
        if (this.workflows != null) {
            component = null;
            count = 0;
            for (Workflow workflow : this.workflows) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setWorkflows(new HashSet<Workflow>());
                    component.setId(this.id + "-" + workflow.getWorkflowId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Workflow " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getWorkflows().add(workflow);
                ++count;
            }
        }
        if (this.users != null) {
            component = null;
            count = 0;
            for (User user : this.users) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setUsers(new HashSet<User>());
                    component.setId(this.id + "-" + user.getUserId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "User " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getUsers().add(user);
                ++count;
            }
        }
        if (this.activityDetails != null) {
            component = null;
            count = 0;
            for (ActivityDetails activityDetail : this.activityDetails) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setActivityDetails(new HashSet<ActivityDetails>());
                    component.setId(this.id + "--" + activityDetail.getActivityKey());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "ActivityDetail " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getActivityDetails().add(activityDetail);
                ++count;
            }
        }
        if (this.activities != null) {
            component = null;
            count = 0;
            for (Activity activity : this.activities) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setActivities(new HashSet<Activity>());
                    component.setId(this.id + "-" + activity.getActivityKey());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Activity " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getActivities().add(activity);
                ++count;
            }
        }
        if (this.nuixCaseStats != null) {
            component = null;
            count = 0;
            for (NuixCaseStat nuixCaseStat : this.nuixCaseStats) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setNuixCaseStats(new ArrayList<NuixCaseStat>());
                    component.setId(this.id + "-" + nuixCaseStat.getNuixCaseId() + nuixCaseStat.getMetricType() + nuixCaseStat.getMetricValue());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "NuixCaseStat " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getNuixCaseStats().add(nuixCaseStat);
                ++count;
            }
        }
        if (this.licenses != null) {
            component = null;
            count = 0;
            for (License license : this.licenses) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setLicenses(new HashSet<License>());
                    component.setId(this.id + "-" + license.getLicenseId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "License " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getLicenses().add(license);
                ++count;
            }
        }
        if (this.organizations != null) {
            component = null;
            count = 0;
            for (Organization organization : this.organizations) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setOrganizations(new HashSet<Organization>());
                    component.setId(this.id + "-" + organization.getOrganizationId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Organization " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getOrganizations().add(organization);
                ++count;
            }
        }
        if (this.collections != null) {
            component = null;
            count = 0;
            for (Collection collection : this.collections) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setCollections(new HashSet<Collection>());
                    component.setId(this.id + "-" + collection.getCollectionId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Collection " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getCollections().add(collection);
                ++count;
            }
        }
        if (this.collectionTargets != null) {
            component = null;
            count = 0;
            for (CollectionTarget collectionTarget : this.collectionTargets) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setCollectionTargets(new HashSet<CollectionTarget>());
                    component.setId(this.id + "-" + collectionTarget.getTargetId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "CollectionTarget " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getCollectionTargets().add(collectionTarget);
                ++count;
            }
        }
        if (this.legalHolds != null) {
            component = null;
            count = 0;
            for (LegalHold legalHold : this.legalHolds) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setLegalHolds(new HashSet<LegalHold>());
                    component.setId(this.id + "-" + legalHold.getLegalHoldId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "LegalHold " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getLegalHolds().add(legalHold);
                ++count;
            }
        }
        if (this.notices != null) {
            component = null;
            count = 0;
            for (Notice notice : this.notices) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setNotices(new HashSet<Notice>());
                    component.setId(this.id + "-" + notice.getNoticeId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "Notice " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getNotices().add(notice);
                ++count;
            }
        }
        if (this.custodianNotices != null) {
            component = null;
            count = 0;
            for (CustodianNotice custodianNotice : this.custodianNotices) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setCustodianNotices(new HashSet<CustodianNotice>());
                    component.setId(this.id + "-" + custodianNotice.getCustodianNoticeId());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "CustodianNotice " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getCustodianNotices().add(custodianNotice);
                ++count;
            }
        }
        if (this.custodianActivities != null) {
            component = null;
            count = 0;
            for (CustodianActivity custodianActivity : this.custodianActivities) {
                if (count >= maxRecords) {
                    count = 0;
                    component = null;
                }
                if (component == null) {
                    component = new UtilizationRecords();
                    component.setCustodianActivities(new HashSet<CustodianActivity>());
                    component.setId(this.id + "-" + custodianActivity.getActivityKey());
                    previousNotes = this.computePreviousNotes();
                    component.properties = new HashMap<String, String>();
                    component.properties.put(UtilizationProperty.NOTES.name(), "CustodianActivity " + results.size() + previousNotes);
                    results.add(component);
                }
                component.getCustodianActivities().add(custodianActivity);
                ++count;
            }
        }
        for (UtilizationRecords utilizationComponent : results) {
            if (utilizationComponent.getProperties() == null) {
                utilizationComponent.setProperties(new HashMap<String, String>());
            }
            utilizationComponent.getProperties().putAll(this.properties);
        }
        return results;
    }

    private String computePreviousNotes() {
        String previousNotes = "";
        if (this.properties != null) {
            previousNotes = this.properties.get(UtilizationProperty.NOTES.name());
            previousNotes = previousNotes == null ? "" : " / " + previousNotes;
        }
        return previousNotes;
    }

    public String toUserFriendlyString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Utilization");
        if (this.consumptionEvents != null) {
            stringBuilder.append(" consumptionEvents:" + this.consumptionEvents.size());
        }
        if (this.clients != null) {
            stringBuilder.append(" clients:" + this.clients.size());
        }
        if (this.dataRepositories != null) {
            stringBuilder.append(" dataRepositories:" + this.dataRepositories.size());
        }
        if (this.dataSets != null) {
            stringBuilder.append(" dataSets:" + this.dataSets.size());
        }
        if (this.transfers != null) {
            stringBuilder.append(" transfers:" + this.transfers.size());
        }
        if (this.transferVolumes != null) {
            stringBuilder.append(" transferVolumes:" + this.transferVolumes.size());
        }
        if (this.engines != null) {
            stringBuilder.append(" engines:" + this.engines.size());
        }
        if (this.executionProfiles != null) {
            stringBuilder.append(" executionProfiles:" + this.executionProfiles.size());
        }
        if (this.jobs != null) {
            stringBuilder.append(" jobs:" + this.jobs.size());
        }
        if (this.libraries != null) {
            stringBuilder.append(" libraries:" + this.libraries.size());
        }
        if (this.matters != null) {
            stringBuilder.append(" matters:" + this.matters.size());
        }
        if (this.nuixCases != null) {
            stringBuilder.append(" nuixCases:" + this.nuixCases.size());
        }
        if (this.relativityWorkspaces != null) {
            stringBuilder.append(" relativityWorkspaces:" + this.relativityWorkspaces.size());
        }
        if (this.operations != null) {
            stringBuilder.append(" operations:" + this.operations.size());
        }
        if (this.resourcePools != null) {
            stringBuilder.append(" resourcePools:" + this.resourcePools.size());
        }
        if (this.servers != null) {
            stringBuilder.append(" servers:" + this.servers.size());
        }
        if (this.sessions != null) {
            stringBuilder.append(" sessions:" + this.sessions.size());
        }
        if (this.workflows != null) {
            stringBuilder.append(" workflows:" + this.workflows.size());
        }
        if (this.users != null) {
            stringBuilder.append(" users:" + this.users.size());
        }
        if (this.activityDetails != null) {
            stringBuilder.append(" activityDetails:" + this.activityDetails.size());
        }
        if (this.activities != null) {
            stringBuilder.append(" activities:" + this.activities.size());
        }
        if (this.nuixCaseStats != null) {
            stringBuilder.append(" nuixCaseStats:" + this.nuixCaseStats.size());
        }
        if (this.licenses != null) {
            stringBuilder.append(" licenses:" + this.licenses.size());
        }
        if (this.organizations != null) {
            stringBuilder.append(" organizations:" + this.organizations.size());
        }
        if (this.collections != null) {
            stringBuilder.append(" collections:" + this.collections.size());
        }
        if (this.collectionTargets != null) {
            stringBuilder.append(" collectionTargets:" + this.collectionTargets.size());
        }
        if (this.legalHolds != null) {
            stringBuilder.append(" legalHolds:" + this.legalHolds.size());
        }
        if (this.notices != null) {
            stringBuilder.append(" notices:" + this.notices.size());
        }
        if (this.custodianNotices != null) {
            stringBuilder.append(" custodianNotices:" + this.custodianNotices.size());
        }
        if (this.custodianActivities != null) {
            stringBuilder.append(" custodianActivities:" + this.custodianActivities.size());
        }
        return stringBuilder.toString();
    }

    public Set<RelativityWorkspace> getRelativityWorkspaces() {
        return this.relativityWorkspaces;
    }

    public void setRelativityWorkspaces(Set<RelativityWorkspace> relativityWorkspaces) {
        this.relativityWorkspaces = relativityWorkspaces;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

