/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.utilization.consumption;

import com.google.common.collect.Iterables;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Consumption
implements Serializable {
    private static final int CONSUMPTION_CUSTODIANS_SPLIT_SIZE = 1000;
    private List<ConsumptionEvent> consumptionEvents;
    private transient boolean isRetry;

    public Consumption() {
        this.consumptionEvents = new ArrayList<ConsumptionEvent>();
    }

    public Consumption(List<ConsumptionEvent> consumptionEvents) {
        this.consumptionEvents = consumptionEvents;
    }

    public List<ConsumptionEvent> getConsumptionEvents() {
        return this.consumptionEvents;
    }

    public void setConsumptionEvents(List<ConsumptionEvent> consumptionEvents) {
        this.consumptionEvents = consumptionEvents;
    }

    public void add(ConsumptionEvent consumptionEvent) {
        this.consumptionEvents.add(consumptionEvent);
    }

    public String getId() {
        if (this.consumptionEvents == null || this.consumptionEvents.size() == 0) {
            return null;
        }
        return this.consumptionEvents.get(0).getConsumptionEventId();
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public void setRetry(boolean retry) {
        this.isRetry = retry;
    }

    public void addConsumptionEvents(ConsumptionEvent templateEvent, Set<String> resourceSubIds) {
        Iterable partitions = Iterables.partition(resourceSubIds, (int)1000);
        for (List partition : partitions) {
            if (partition.size() <= 0) continue;
            ConsumptionEvent copyEvent = templateEvent.clone();
            copyEvent.setConsumptionEventId(UidUtils.getRandom());
            copyEvent.setResourceSubId(SerializationUtils.toJson(partition));
            copyEvent.setUnits(partition.size());
            this.add(copyEvent);
        }
    }
}

